<?php
// /app/operations/workorders_ajax.php
declare(strict_types=1);

require_once __DIR__ . '/_lib.php';

header('Content-Type: application/json; charset=utf-8');

$companyId = ops_require_company_scope();
if (!ops_can_manage()) { http_response_code(403); echo json_encode(['ok'=>false,'msg'=>'Forbidden']); exit; }

csrf_verify();

$pdo = db_safe();

$action = (string)($_POST['action'] ?? '');
$id = (int)($_POST['id'] ?? 0);
$value = $_POST['value'] ?? null;

if ($id <= 0) { http_response_code(400); echo json_encode(['ok'=>false,'msg'=>'Missing id']); exit; }

$wo = $pdo->prepare("SELECT * FROM ops_work_orders WHERE id=:id AND company_id=:cid");
$wo->execute([':id'=>$id, ':cid'=>$companyId]);
$row = $wo->fetch(PDO::FETCH_ASSOC);
if (!$row) { http_response_code(404); echo json_encode(['ok'=>false,'msg'=>'Work order not found']); exit; }

try {
  if ($action === 'status') {
    $allowed = ['new','scheduled','in_progress','blocked','completed','canceled'];
    $st = (string)$value;
    if (!in_array($st, $allowed, true)) throw new RuntimeException('Invalid status');

    $completedAt = null;
    if ($st === 'completed') $completedAt = (new DateTime('now', new DateTimeZone('UTC')))->format('Y-m-d H:i:s');

    $upd = $pdo->prepare("UPDATE ops_work_orders SET status=:st, completed_at=COALESCE(:ca, completed_at) WHERE id=:id AND company_id=:cid");
    $upd->execute([':st'=>$st, ':ca'=>$completedAt, ':id'=>$id, ':cid'=>$companyId]);

    $pdo->prepare("INSERT INTO ops_work_order_events (work_order_id, actor_user_id, event_type, message) VALUES (:wo,:uid,'status_change',:msg)")
        ->execute([
          ':wo'=>$id,
          ':uid'=> function_exists('current_user_id') ? (int)current_user_id() : null,
          ':msg'=> 'Status set to '.$st
        ]);

    echo json_encode(['ok'=>true]);
    exit;
  }

  if ($action === 'lead') {
    $uid = (int)$value;
    if ($uid < 0) $uid = 0;

    // Remove existing lead
    $pdo->prepare("DELETE FROM ops_work_order_assignees WHERE work_order_id=:wo AND role='lead'")
        ->execute([':wo'=>$id]);

    if ($uid > 0) {
      $pdo->prepare("INSERT INTO ops_work_order_assignees (work_order_id, user_id, role) VALUES (:wo,:uid,'lead')")
          ->execute([':wo'=>$id, ':uid'=>$uid]);
    }

    $pdo->prepare("INSERT INTO ops_work_order_events (work_order_id, actor_user_id, event_type, message, meta_json) VALUES (:wo,:actor,'assign_lead',:msg, :meta)")
        ->execute([
          ':wo'=>$id,
          ':actor'=> function_exists('current_user_id') ? (int)current_user_id() : null,
          ':msg'=> $uid>0 ? 'Lead assigned' : 'Lead unassigned',
          ':meta'=> json_encode(['lead_user_id'=>$uid], JSON_UNESCAPED_SLASHES)
        ]);

    echo json_encode(['ok'=>true]);
    exit;
  }

  http_response_code(400);
  echo json_encode(['ok'=>false,'msg'=>'Unknown action']);
} catch (Throwable $e) {
  http_response_code(400);
  echo json_encode(['ok'=>false,'msg'=>$e->getMessage()]);
}
