<?php
// /app/operations/workorder_tasks_ajax.php
declare(strict_types=1);

require_once __DIR__ . '/_lib.php';

header('Content-Type: application/json; charset=utf-8');

$companyId = ops_require_company_scope();
if (!ops_can_view()) { http_response_code(403); echo json_encode(['ok'=>false,'msg'=>'Forbidden']); exit; }

csrf_verify();

$pdo = db_safe();

$action = (string)($_POST['action'] ?? '');
$workOrderId = (int)($_POST['work_order_id'] ?? 0);
if ($workOrderId <= 0) { http_response_code(400); echo json_encode(['ok'=>false,'msg'=>'Missing work_order_id']); exit; }

$wo = $pdo->prepare("SELECT id FROM ops_work_orders WHERE id=:id AND company_id=:cid");
$wo->execute([':id'=>$workOrderId, ':cid'=>$companyId]);
if (!$wo->fetchColumn()) { http_response_code(404); echo json_encode(['ok'=>false,'msg'=>'Work order not found']); exit; }

$actor = function_exists('current_user_id') ? (int)current_user_id() : null;

try {
  if ($action === 'add') {
    if (!ops_can_manage()) throw new RuntimeException('Forbidden');
    $title = trim((string)($_POST['title'] ?? ''));
    if ($title === '') throw new RuntimeException('Title required');

    $sort = (int)($pdo->query("SELECT COALESCE(MAX(sort_order),100) FROM ops_work_order_tasks WHERE work_order_id=".(int)$workOrderId)->fetchColumn() ?: 100);
    $sort += 10;

    $pdo->prepare("INSERT INTO ops_work_order_tasks (work_order_id, title, sort_order) VALUES (:wo,:t,:s)")
        ->execute([':wo'=>$workOrderId, ':t'=>$title, ':s'=>$sort]);

    $pdo->prepare("INSERT INTO ops_work_order_events (work_order_id, actor_user_id, event_type, message) VALUES (:wo,:uid,'task_added',:msg)")
        ->execute([':wo'=>$workOrderId, ':uid'=>$actor, ':msg'=>'Task added: '.$title]);

    echo json_encode(['ok'=>true]);
    exit;
  }

  if ($action === 'toggle') {
    $taskId = (int)($_POST['task_id'] ?? 0);
    $done = (string)($_POST['done'] ?? '0') === '1';

    $task = $pdo->prepare("SELECT t.id FROM ops_work_order_tasks t WHERE t.id=:tid AND t.work_order_id=:wo");
    $task->execute([':tid'=>$taskId, ':wo'=>$workOrderId]);
    if (!$task->fetchColumn()) throw new RuntimeException('Task not found');

    $status = $done ? 'done' : 'open';
    $completedAt = $done ? (new DateTime('now', new DateTimeZone('UTC')))->format('Y-m-d H:i:s') : null;

    $pdo->prepare("UPDATE ops_work_order_tasks SET status=:st, completed_at=:ca WHERE id=:id")
        ->execute([':st'=>$status, ':ca'=>$completedAt, ':id'=>$taskId]);

    echo json_encode(['ok'=>true]);
    exit;
  }

  if ($action === 'delete') {
    if (!ops_can_manage()) throw new RuntimeException('Forbidden');
    $taskId = (int)($_POST['task_id'] ?? 0);

    $pdo->prepare("DELETE FROM ops_work_order_tasks WHERE id=:id AND work_order_id=:wo")
        ->execute([':id'=>$taskId, ':wo'=>$workOrderId]);

    $pdo->prepare("INSERT INTO ops_work_order_events (work_order_id, actor_user_id, event_type, message) VALUES (:wo,:uid,'task_deleted','Task deleted')")
        ->execute([':wo'=>$workOrderId, ':uid'=>$actor]);

    echo json_encode(['ok'=>true]);
    exit;
  }

  http_response_code(400);
  echo json_encode(['ok'=>false,'msg'=>'Unknown action']);
} catch (Throwable $e) {
  http_response_code(400);
  echo json_encode(['ok'=>false,'msg'=>$e->getMessage()]);
}
