<?php
// /app/operations/webhook_key_save.php
declare(strict_types=1);

require_once __DIR__ . '/_lib.php';

$companyId = ops_require_company_scope();
if (!ops_can_webhooks()) { http_response_code(403); exit('Forbidden'); }

csrf_verify();

$pdo = db_safe();

$id = (int)($_POST['id'] ?? 0);
$toggle = (int)($_POST['toggle'] ?? 0);

if ($toggle === 1 && $id > 0) {
  $pdo->prepare("UPDATE ops_webhook_keys SET is_enabled = 1 - is_enabled WHERE id=:id AND company_id=:cid")
      ->execute([':id'=>$id, ':cid'=>$companyId]);
  header('Location: /app/operations/services.php');
  exit;
}

$label = trim((string)($_POST['label'] ?? ''));
if ($label === '') { http_response_code(400); exit('Label required'); }

$key = bin2hex(random_bytes(20)); // 40 chars

$pdo->prepare("INSERT INTO ops_webhook_keys (company_id, label, api_key, created_by) VALUES (:cid,:label,:k,:uid)")
    ->execute([
      ':cid'=>$companyId,
      ':label'=>$label,
      ':k'=>$key,
      ':uid'=> function_exists('current_user_id') ? (int)current_user_id() : null
    ]);

header('Location: /app/operations/services.php');
exit;
