<?php
// /app/operations/service_edit.php
declare(strict_types=1);

require_once __DIR__ . '/_lib.php';

$pageTitle = 'Service';
$activeNav = 'operations';

$companyId = ops_require_company_scope();
if (!ops_can_configure()) { http_response_code(403); exit('Forbidden'); }

$pdo = db_safe();

$idRaw = (string)($_GET['id'] ?? '0');
$isNew = ($idRaw === 'new');
$id = $isNew ? 0 : (int)$idRaw;

$svc = [
  'id'=>0,'service_code'=>'','service_name'=>'','description'=>'',
  'default_priority'=>3,'default_due_days'=>7,'default_assignee_user_id'=>null,'is_active'=>1
];

if (!$isNew) {
  $st = $pdo->prepare("SELECT * FROM ops_services WHERE id=:id AND company_id=:cid");
  $st->execute([':id'=>$id, ':cid'=>$companyId]);
  $row = $st->fetch(PDO::FETCH_ASSOC);
  if (!$row) { http_response_code(404); exit('Not found'); }
  $svc = $row;
}

/* Assignee list */
$techs = [];
try {
  $qTech = $pdo->prepare("
    SELECT id, CONCAT(first_name,' ',last_name) AS name
    FROM users
    WHERE tenant_type='company' AND tenant_id=:cid AND is_active=1
    ORDER BY first_name, last_name
  ");
  $qTech->execute([':cid'=>$companyId]);
  $techs = $qTech->fetchAll(PDO::FETCH_KEY_PAIR);
} catch (Throwable $e) {
  $techs = $pdo->query("SELECT id, CONCAT(first_name,' ',last_name) AS name FROM users ORDER BY first_name, last_name")
               ->fetchAll(PDO::FETCH_KEY_PAIR);
}

require_once __DIR__ . '/includes/header.php';
$activeOps = 'services';
require __DIR__ . '/_subnav.php';
?>
<div class="card shadow-sm">
  <div class="card-header bg-dark text-white"><strong><?= $isNew ? 'Add Service' : 'Edit Service' ?></strong></div>
  <div class="card-body">
    <form method="post" action="/app/operations/service_save.php" class="row g-3">
      <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
      <input type="hidden" name="id" value="<?= (int)$svc['id'] ?>">

      <div class="col-12 col-md-6">
        <label class="form-label">Service Name</label>
        <input class="form-control" name="service_name" value="<?=h((string)$svc['service_name'])?>" required>
      </div>
      <div class="col-12 col-md-6">
        <label class="form-label">Service Code</label>
        <input class="form-control" name="service_code" value="<?=h((string)$svc['service_code'])?>" placeholder="electrical, minisplit, spray_foam" required>
        <div class="form-text">Unique per company. Used internally for reporting and automation.</div>
      </div>

      <div class="col-12">
        <label class="form-label">Description</label>
        <textarea class="form-control" name="description" rows="2"><?=h((string)($svc['description'] ?? ''))?></textarea>
      </div>

      <div class="col-6 col-md-3">
        <label class="form-label">Default Priority</label>
        <select class="form-select" name="default_priority">
          <?php for ($p=1;$p<=5;$p++): ?>
            <option value="<?=$p?>" <?=$p==(int)$svc['default_priority']?'selected':''?>><?=$p?></option>
          <?php endfor; ?>
        </select>
      </div>

      <div class="col-6 col-md-3">
        <label class="form-label">Default Due Days</label>
        <input type="number" min="0" class="form-control" name="default_due_days" value="<?= (int)$svc['default_due_days'] ?>">
      </div>

      <div class="col-12 col-md-4">
        <label class="form-label">Default Assignee</label>
        <select class="form-select" name="default_assignee_user_id">
          <option value="">— none —</option>
          <?php foreach ($techs as $uid=>$name): ?>
            <option value="<?= (int)$uid ?>" <?= ((string)$svc['default_assignee_user_id'] !== '' && (int)$svc['default_assignee_user_id']===(int)$uid) ? 'selected':'' ?>><?=h((string)$name)?></option>
          <?php endforeach; ?>
        </select>
      </div>

      <div class="col-12 col-md-2">
        <label class="form-label">Active</label>
        <select class="form-select" name="is_active">
          <option value="1" <?= (int)$svc['is_active']===1?'selected':'' ?>>Yes</option>
          <option value="0" <?= (int)$svc['is_active']===0?'selected':'' ?>>No</option>
        </select>
      </div>

      <div class="col-12 d-flex gap-2">
        <button class="btn btn-primary" type="submit"><?= $isNew ? 'Create' : 'Save' ?></button>
        <a class="btn btn-outline-dark" href="/app/operations/services.php">Back</a>
      </div>
    </form>
  </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
