<?php
// /app/operations/includes/db_config.php
declare(strict_types=1);

/**
 * ShedOffice DB config.
 * This file is included by Operations cron + webhook handlers and should match your production database.
 *
 * Note: Values below are defaults/placeholders; update DB_HOST/DB_USER/DB_PASS as needed.
 */

if (!defined('DB_HOST')) define('DB_HOST', getenv('DB_HOST') ?: 'localhost');
if (!defined('DB_USER')) define('DB_USER', getenv('DB_USER') ?: 'YOUR_DB_USER');
if (!defined('DB_PASS')) define('DB_PASS', getenv('DB_PASS') ?: 'YOUR_DB_PASS');

// Required per your system:
if (!defined('DB_NAME')) define('DB_NAME', getenv('DB_NAME') ?: 'shedoffice_main');

// Optional:
if (!defined('DB_CHARSET')) define('DB_CHARSET', 'utf8mb4');
