<?php
// /app/operations/addon_mapping_save.php
declare(strict_types=1);

require_once __DIR__ . '/_lib.php';

$companyId = ops_require_company_scope();
if (!ops_can_configure()) { http_response_code(403); exit('Forbidden'); }

csrf_verify();
$pdo = db_safe();

$id = (int)($_POST['id'] ?? 0);
$isNew = ($id <= 0);

$serviceId = (int)($_POST['service_id'] ?? 0);
$matchType = (string)($_POST['match_type'] ?? 'contains');
$matchValue = trim((string)($_POST['match_value'] ?? ''));
$priority = max(1, (int)($_POST['priority'] ?? 100));
$isActive = (int)($_POST['is_active'] ?? 1) === 1 ? 1 : 0;

if ($serviceId <= 0 || $matchValue === '') { http_response_code(400); exit('Missing fields'); }
if (!in_array($matchType, ['exact','contains','regex'], true)) $matchType = 'contains';

$svc = $pdo->prepare("SELECT id FROM ops_services WHERE id=:id AND company_id=:cid");
$svc->execute([':id'=>$serviceId, ':cid'=>$companyId]);
if (!$svc->fetchColumn()) { http_response_code(400); exit('Invalid service'); }

if ($matchType === 'regex') {
  // Validate regex: accept both /pattern/flags and bare pattern
  $pattern = $matchValue;
  $ok = @preg_match($pattern, '') !== false;
  if (!$ok) {
    $pattern = '/'.str_replace('/','\/', $matchValue).'/i';
    $ok = @preg_match($pattern, '') !== false;
  }
  if (!$ok) { http_response_code(400); exit('Invalid regex'); }
}

if ($isNew) {
  $pdo->prepare("
    INSERT INTO ops_addon_service_map (company_id, service_id, match_type, match_value, priority, is_active)
    VALUES (:cid,:sid,:mt,:mv,:p,:a)
  ")->execute([':cid'=>$companyId, ':sid'=>$serviceId, ':mt'=>$matchType, ':mv'=>$matchValue, ':p'=>$priority, ':a'=>$isActive]);
  header('Location: /app/operations/addon_mapping.php');
  exit;
}

$pdo->prepare("
  UPDATE ops_addon_service_map
     SET service_id=:sid, match_type=:mt, match_value=:mv, priority=:p, is_active=:a
   WHERE id=:id AND company_id=:cid
")->execute([':sid'=>$serviceId, ':mt'=>$matchType, ':mv'=>$matchValue, ':p'=>$priority, ':a'=>$isActive, ':id'=>$id, ':cid'=>$companyId]);

header('Location: /app/operations/addon_mapping.php');
exit;
