<?php
// /app/dev/auth_trace.php
declare(strict_types=1);

ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/auth.php';

header('Content-Type: text/plain');

start_secure_session();

echo "=== AUTH TRACE ===\n";
echo "Time: " . date('c') . "\n";
echo "Request URI: " . ($_SERVER['REQUEST_URI'] ?? '') . "\n";
echo "HTTPS: " . ($_SERVER['HTTPS'] ?? '') . "\n";
echo "X-Forwarded-Proto: " . ($_SERVER['HTTP_X_FORWARDED_PROTO'] ?? '') . "\n";
echo "Session name: " . session_name() . "\n";
echo "Session id: " . session_id() . "\n\n";

echo "COOKIE keys: " . implode(', ', array_keys($_COOKIE ?? [])) . "\n\n";

echo "is_logged_in(): " . (is_logged_in() ? "YES" : "NO") . "\n";
echo "current_user_id(): " . (string)(current_user_id() ?? 'NULL') . "\n";
echo "current_tenant_id(): " . (string)(current_tenant_id() ?? 'NULL') . "\n";
echo "current_tenant_type(): " . (string)(current_tenant_type() ?? 'NULL') . "\n";
echo "active_company_tenant_id(): " . (string)(active_company_tenant_id() ?? 'NULL') . "\n\n";

echo "SESSION auth:\n";
print_r($_SESSION['auth'] ?? null);

echo "\n=== WHAT THE GUARDS WOULD DO ===\n";
echo is_logged_in() ? "require_login() would PASS\n" : "require_login() would redirect to: " . app_path('index.php') . "\n";

if (is_logged_in() && current_tenant_type() === 'rto' && !active_company_tenant_id()) {
  echo "require_company_context_if_rto() would redirect to: " . app_path('select_company.php') . "\n";
} else {
  echo "require_company_context_if_rto() would PASS\n";
}

echo "\n=== INCLUDE ACL + SCOPE (step-by-step) ===\n";

echo "Step 1: include acl.php...\n";
try {
  require_once __DIR__ . '/../includes/acl.php';
  echo "OK: acl.php included\n";
} catch (Throwable $e) {
  echo "FAIL: acl.php include exception: " . $e->getMessage() . "\n";
  exit;
}

echo "Step 2: include scope.php...\n";
try {
  require_once __DIR__ . '/../includes/scope.php';
  echo "OK: scope.php included\n";
} catch (Throwable $e) {
  echo "FAIL: scope.php include exception: " . $e->getMessage() . "\n";
  exit;
}

echo "Step 3: run acl_bootstrap...\n";
try {
  $pdo = db();
  acl_bootstrap($pdo);
  echo "OK: acl_bootstrap executed\n";
} catch (Throwable $e) {
  echo "FAIL: acl_bootstrap exception: " . $e->getMessage() . "\n";
  exit;
}

echo "Step 4: call company_context_id()...\n";
try {
  echo "company_context_id(): " . company_context_id() . "\n";
} catch (Throwable $e) {
  echo "FAIL: company_context_id exception: " . $e->getMessage() . "\n";
  exit;
}

echo "\nDONE\n";
