<?php
// /app/admin/repo_width_rule_save.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_login();
require_once __DIR__ . '/../includes/acl.php';

if (!csrf_validate((string)($_POST['_csrf'] ?? ''))) {
  http_response_code(403);
  echo 'CSRF validation failed.';
  exit;
}

$pdo = db();
acl_bootstrap($pdo);

$tenantType = current_tenant_type();
if ($tenantType === 'rto') { http_response_code(403); exit; }

$isCompanyAdmin = user_has_role('company_admin');
$isManager = user_has_role('manager');
if (!$isCompanyAdmin && !$isManager) { http_response_code(403); exit; }

$companyTenantId = (int) current_tenant_id();

$scheduleId = (int)($_POST['schedule_id'] ?? 0);
$widthFt = (int)($_POST['width_ft'] ?? 0);
$baseFee = (float)($_POST['base_fee'] ?? 0);
$baseLenMax = (int)($_POST['base_length_max_ft'] ?? 0);
$stepFt = (int)($_POST['extra_length_step_ft'] ?? 1);
$stepFee = (float)($_POST['extra_length_fee_per_step'] ?? 0);

if ($scheduleId < 1 || $widthFt < 1 || $baseFee < 0 || $baseLenMax < 1 || $stepFt < 1 || $stepFee < 0) {
  http_response_code(400);
  echo "Invalid width rule fields.";
  exit;
}

// Ensure schedule belongs to tenant
$stmt = $pdo->prepare("SELECT id FROM repo_fee_schedules WHERE id=:sid1 AND tenant_id=:tid1 LIMIT 1");
$stmt->execute([':sid1' => $scheduleId, ':tid1' => $companyTenantId]);
if (!$stmt->fetchColumn()) {
  http_response_code(403);
  echo "Invalid schedule.";
  exit;
}

// Upsert by (schedule_id,width_ft)
$stmt = $pdo->prepare("
  INSERT INTO repo_fee_width_rules (schedule_id, width_ft, base_fee, base_length_max_ft, extra_length_step_ft, extra_length_fee_per_step)
  VALUES (:sid1, :w1, :bf1, :bl1, :st1, :sf1)
  ON DUPLICATE KEY UPDATE
    base_fee=VALUES(base_fee),
    base_length_max_ft=VALUES(base_length_max_ft),
    extra_length_step_ft=VALUES(extra_length_step_ft),
    extra_length_fee_per_step=VALUES(extra_length_fee_per_step)
");
$stmt->execute([
  ':sid1' => $scheduleId,
  ':w1' => $widthFt,
  ':bf1' => $baseFee,
  ':bl1' => $baseLenMax,
  ':st1' => $stepFt,
  ':sf1' => $stepFee,
]);

header('Location: ' . app_path('admin/repo_fee_settings.php?tab=company&ok=1'));
exit;
