<?php
// /app/admin/repo_schedule_save.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_login();
require_once __DIR__ . '/../includes/acl.php';

if (!csrf_validate((string)($_POST['_csrf'] ?? ''))) {
  http_response_code(403);
  echo 'CSRF validation failed.';
  exit;
}

$pdo = db();
acl_bootstrap($pdo);

$tenantType = current_tenant_type();
if ($tenantType === 'rto') { http_response_code(403); exit; }

$isCompanyAdmin = user_has_role('company_admin');
$isManager = user_has_role('manager');
if (!$isCompanyAdmin && !$isManager) { http_response_code(403); exit; }

$companyTenantId = (int) current_tenant_id();

$id = (int)($_POST['id'] ?? 0);
$appliesTo = trim((string)($_POST['applies_to'] ?? 'company'));
if (!in_array($appliesTo, ['company','rto'], true)) $appliesTo = 'company';

$rtoTenantId = null;
if ($appliesTo === 'rto') {
  $rt = (int)($_POST['rto_tenant_id'] ?? 0);
  if ($rt > 0) $rtoTenantId = $rt;
}

$name = trim((string)($_POST['name'] ?? ''));
$included = (int)($_POST['included_miles'] ?? 0);
$maxMiles = (int)($_POST['max_billable_miles'] ?? 0);
$perMile = (float)($_POST['per_mile_fee'] ?? 0);
$isActive = isset($_POST['is_active']) ? 1 : 0;

if ($name === '' || $included < 0 || $maxMiles < 0 || $perMile < 0) {
  http_response_code(400);
  echo "Invalid schedule fields.";
  exit;
}

if ($id > 0) {
  $stmt = $pdo->prepare("
    UPDATE repo_fee_schedules
    SET name=:n1,
        is_active=:a1,
        included_miles=:i1,
        max_billable_miles=:m1,
        per_mile_fee=:p1,
        rto_tenant_id=:rto1
    WHERE id=:id1 AND tenant_id=:tid1
  ");
  $stmt->execute([
    ':n1' => $name,
    ':a1' => $isActive,
    ':i1' => $included,
    ':m1' => $maxMiles,
    ':p1' => $perMile,
    ':rto1' => $rtoTenantId,
    ':id1' => $id,
    ':tid1' => $companyTenantId,
  ]);
} else {
  $stmt = $pdo->prepare("
    INSERT INTO repo_fee_schedules (tenant_id, applies_to, rto_tenant_id, name, is_active, included_miles, max_billable_miles, per_mile_fee, created_at)
    VALUES (:tid1, :ap1, :rto1, :n1, :a1, :i1, :m1, :p1, CURRENT_TIMESTAMP)
  ");
  $stmt->execute([
    ':tid1' => $companyTenantId,
    ':ap1' => $appliesTo,
    ':rto1' => $rtoTenantId,
    ':n1' => $name,
    ':a1' => $isActive,
    ':i1' => $included,
    ':m1' => $maxMiles,
    ':p1' => $perMile,
  ]);
}

$tab = ($appliesTo === 'rto') ? 'rto' : 'company';
header('Location: ' . app_path("admin/repo_fee_settings.php?tab={$tab}&ok=1"));
exit;
