<?php
// /app/admin/repo_fee_settings_save.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_login();

require_once __DIR__ . '/../includes/acl.php';

if (!csrf_validate((string)($_POST['_csrf'] ?? ''))) {
  http_response_code(403);
  echo 'CSRF validation failed.';
  exit;
}

$pdo = db();
acl_bootstrap($pdo);

$tenantType = current_tenant_type();
if ($tenantType === 'rto') { http_response_code(403); exit; }

$isCompanyAdmin = user_has_role('company_admin');
$isManager = user_has_role('manager');
if (!$isCompanyAdmin && !$isManager) { http_response_code(403); exit; }

$companyTenantId = (int) current_tenant_id();

$billTo = trim((string)($_POST['repo_invoice_bill_to'] ?? 'rto'));
if (!in_array($billTo, ['company','rto'], true)) $billTo = 'rto';

$driverOverride = isset($_POST['driver_can_override_repo_invoice']) ? 1 : 0;
$driverCustom = isset($_POST['driver_can_submit_custom_invoice']) ? 1 : 0;

$stmt = $pdo->prepare("
  INSERT INTO tenant_settings (tenant_id, repo_invoice_bill_to, driver_can_override_repo_invoice, driver_can_submit_custom_invoice, created_at, updated_at)
  VALUES (:tid1, :bt1, :d1, :c1, CURRENT_TIMESTAMP, CURRENT_TIMESTAMP)
  ON DUPLICATE KEY UPDATE
    repo_invoice_bill_to=VALUES(repo_invoice_bill_to),
    driver_can_override_repo_invoice=VALUES(driver_can_override_repo_invoice),
    driver_can_submit_custom_invoice=VALUES(driver_can_submit_custom_invoice),
    updated_at=CURRENT_TIMESTAMP
");
$stmt->execute([
  ':tid1' => $companyTenantId,
  ':bt1' => $billTo,
  ':d1' => $driverOverride,
  ':c1' => $driverCustom,
]);

header('Location: ' . app_path('admin/repo_fee_settings.php?tab=company&ok=1'));
exit;
