<?php
// /app/underwriting/settings.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/scope.php';

$pageTitle = 'Underwriting Settings';
$activeNav = 'underwriting';
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/_uw.php';

require_company_context_if_rto();
$pdo = db();
$tenantId = uw_company_tid();

$settings = uw_get_settings($pdo, $tenantId);
$flash = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_validate((string)($_POST['_csrf'] ?? ''))) {
    http_response_code(403);
    echo 'CSRF validation failed.';
    exit;
  }

  $settings['openai_api_key'] = trim((string)($_POST['openai_api_key'] ?? ''));
  $settings['openai_model'] = trim((string)($_POST['openai_model'] ?? 'gpt-4.1-mini'));
  $settings['google_cse_key'] = trim((string)($_POST['google_cse_key'] ?? ''));
  $settings['google_cse_cx'] = trim((string)($_POST['google_cse_cx'] ?? ''));
  $settings['softpull_base_url'] = trim((string)($_POST['softpull_base_url'] ?? ''));
  $settings['softpull_username'] = trim((string)($_POST['softpull_username'] ?? ''));
  $settings['softpull_password'] = trim((string)($_POST['softpull_password'] ?? ''));

  $settings['risk_threshold_pass'] = max(0, min(100, (int)($_POST['risk_threshold_pass'] ?? 29)));
  $settings['risk_threshold_review'] = max(0, min(100, (int)($_POST['risk_threshold_review'] ?? 54)));
  $settings['risk_threshold_fail'] = max(0, min(100, (int)($_POST['risk_threshold_fail'] ?? 55)));

  uw_save_settings($pdo, $tenantId, $settings);
  $flash = 'Settings saved.';
}

$csrf = csrf_token();
?>

<div class="container-fluid">
  <div class="row">
    <div class="col-12">
      <div class="so-page-title">Underwriting Settings</div>
      <div class="so-page-sub">Configure API keys and underwriting thresholds.</div>
    </div>
  </div>

  <?php if ($flash): ?>
    <div class="row"><div class="col-12"><div class="alert alert-success so-card"><?= h($flash) ?></div></div></div>
  <?php endif; ?>

  <div class="row g-3">
    <div class="col-12 col-lg-8">
      <div class="so-card p-3">
        <form method="post" action="">
          <input type="hidden" name="_csrf" value="<?= h($csrf) ?>">

          <div class="so-side-section">OpenAI</div>
          <div class="row g-2">
            <div class="col-12">
              <label class="form-label">OpenAI API Key</label>
              <input class="form-control" name="openai_api_key" value="<?= h($settings['openai_api_key']) ?>" placeholder="sk-...">
              <div class="text-muted" style="font-size:12px;">Stored in DB per tenant. Consider encrypting at rest.</div>
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">Model</label>
              <input class="form-control" name="openai_model" value="<?= h($settings['openai_model']) ?>">
            </div>
          </div>

          <hr class="my-3" style="border-color:rgba(255,255,255,0.08);">

          <div class="so-side-section">Google Custom Search API</div>
          <div class="row g-2">
            <div class="col-12 col-md-6">
              <label class="form-label">API Key</label>
              <input class="form-control" name="google_cse_key" value="<?= h($settings['google_cse_key']) ?>">
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">Search Engine CX</label>
              <input class="form-control" name="google_cse_cx" value="<?= h($settings['google_cse_cx']) ?>">
            </div>
            <div class="col-12">
              <div class="text-muted" style="font-size:12px;">Used for delivery risk + public records searches. No scraping.</div>
            </div>
          </div>

          <hr class="my-3" style="border-color:rgba(255,255,255,0.08);">

          <div class="so-side-section">SoftPullSolutions</div>
          <div class="row g-2">
            <div class="col-12">
              <label class="form-label">Base URL</label>
              <input class="form-control" name="softpull_base_url" value="<?= h($settings['softpull_base_url']) ?>" placeholder="https://...">
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">Username</label>
              <input class="form-control" name="softpull_username" value="<?= h($settings['softpull_username']) ?>">
            </div>
            <div class="col-12 col-md-6">
              <label class="form-label">Password</label>
              <input class="form-control" type="password" name="softpull_password" value="<?= h($settings['softpull_password']) ?>">
            </div>
          </div>

          <hr class="my-3" style="border-color:rgba(255,255,255,0.08);">

          <div class="so-side-section">Risk thresholds</div>
          <div class="row g-2">
            <div class="col-12 col-md-4">
              <label class="form-label">Pass max</label>
              <input class="form-control" name="risk_threshold_pass" value="<?= (int)$settings['risk_threshold_pass'] ?>">
            </div>
            <div class="col-12 col-md-4">
              <label class="form-label">Review max</label>
              <input class="form-control" name="risk_threshold_review" value="<?= (int)$settings['risk_threshold_review'] ?>">
            </div>
            <div class="col-12 col-md-4">
              <label class="form-label">Fail min</label>
              <input class="form-control" name="risk_threshold_fail" value="<?= (int)$settings['risk_threshold_fail'] ?>">
            </div>
          </div>

          <div class="d-flex gap-2 mt-3">
            <button class="btn btn-primary" type="submit"><i class="fa-solid fa-floppy-disk"></i> Save</button>
            <a class="btn btn-outline-light" href="<?= app_path('underwriting/index.php') ?>">Back</a>
          </div>
        </form>
      </div>
    </div>

    <div class="col-12 col-lg-4">
      <div class="so-card p-3">
        <div style="font-weight:800;" class="mb-2">Implementation notes</div>
        <ul class="text-muted" style="margin:0; padding-left: 18px; font-size:13px;">
          <li>ID verification and signature compare use OpenAI file + responses APIs.</li>
          <li>SoftPullSolutions uses bearer token + standardInquiry + reviewReport.</li>
          <li>For best fake-ID detection, require back-of-ID photos for barcode consistency checks.</li>
        </ul>
      </div>
    </div>
  </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
