<?php
// /app/underwriting/index.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/scope.php';

$pageTitle = 'Underwriting';
$activeNav = 'underwriting';
require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/_uw.php';

require_company_context_if_rto();

$pdo = db();
$tenantId = uw_company_tid();

$statusFilter = (string)($_GET['status'] ?? 'open');
$search = trim((string)($_GET['q'] ?? ''));

$where = ['o.tenant_id = :tid'];
$params = [':tid' => $tenantId];

if ($statusFilter !== '' && $statusFilter !== 'all') {
  $where[] = 'COALESCE(uc.status,\'open\') = :st';
  $params[':st'] = $statusFilter;
}

if ($search !== '') {
  $where[] = '(o.order_number LIKE :q OR o.customer_name LIKE :q OR o.customer_phone_primary LIKE :q)';
  $params[':q'] = '%' . $search . '%';
}

$sql = "
  SELECT
    o.id,
    o.order_number,
    o.customer_name,
    o.customer_phone_primary,
    o.delivery_city,
    o.delivery_state,
    o.total,
    o.status AS order_status,
    uc.status AS uw_status,
    uc.risk_score,
    uc.updated_at AS uw_updated
  FROM orders o
  LEFT JOIN underwriting_cases uc
    ON uc.tenant_id = o.tenant_id AND uc.order_id = o.id
  WHERE " . implode(' AND ', $where) . "
  ORDER BY COALESCE(uc.updated_at, o.updated_at) DESC
  LIMIT 200
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<div class="container-fluid">
  <div class="row">
    <div class="col-12">
      <div class="so-page-title">Underwriting</div>
      <div class="so-page-sub">Review and score deals to reduce fraud, theft, and first-payment defaults.</div>
    </div>
  </div>

  <div class="row g-3 mb-3">
    <div class="col-12 col-lg-8">
      <div class="so-card p-3">
        <form class="row g-2" method="get" action="">
          <div class="col-12 col-md-4">
            <label class="form-label">Status</label>
            <select class="form-select" name="status">
              <?php
              $opts = ['open'=>'Open','approved'=>'Approved','conditional'=>'Conditional','denied'=>'Denied','all'=>'All'];
              foreach ($opts as $k=>$v):
              ?>
                <option value="<?= h($k) ?>" <?= $statusFilter===$k?'selected':'' ?>><?= h($v) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-12 col-md-6">
            <label class="form-label">Search</label>
            <input class="form-control" name="q" value="<?= h($search) ?>" placeholder="Order #, customer, phone">
          </div>
          <div class="col-12 col-md-2 d-flex align-items-end">
            <button class="btn btn-primary w-100" type="submit"><i class="fa-solid fa-magnifying-glass"></i> Filter</button>
          </div>
        </form>
      </div>
    </div>

    <div class="col-12 col-lg-4">
      <div class="so-card p-3">
        <div class="d-flex justify-content-between align-items-center">
          <div>
            <div class="text-muted">Settings</div>
            <div style="font-weight:700;">API keys & scoring thresholds</div>
          </div>
          <a class="btn btn-outline-light" href="<?= app_path('underwriting/settings.php') ?>">
            <i class="fa-solid fa-gear"></i> Configure
          </a>
        </div>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-12">
      <div class="so-card">
        <div class="table-responsive">
          <table class="table so-table mb-0">
            <thead>
              <tr>
                <th>Order</th>
                <th>Customer</th>
                <th>Delivery</th>
                <th>Total</th>
                <th>UW Status</th>
                <th>Risk</th>
                <th>Updated</th>
                <th></th>
              </tr>
            </thead>
            <tbody>
              <?php if (!$rows): ?>
                <tr><td colspan="8" class="text-muted p-4">No orders found for this filter.</td></tr>
              <?php else: foreach ($rows as $r):
                $uwStatus = $r['uw_status'] ?: 'open';
                $risk = (int)($r['risk_score'] ?? 0);
              ?>
                <tr>
                  <td>
                    <div style="font-weight:700;">#<?= h($r['order_number'] ?? '') ?></div>
                    <div class="text-muted" style="font-size:12px;">Order ID <?= (int)$r['id'] ?></div>
                  </td>
                  <td>
                    <div style="font-weight:700;"><?= h($r['customer_name'] ?? '') ?></div>
                    <div class="text-muted" style="font-size:12px;"><?= h($r['customer_phone_primary'] ?? '') ?></div>
                  </td>
                  <td>
                    <div><?= h(($r['delivery_city'] ?? '') . ', ' . ($r['delivery_state'] ?? '')) ?></div>
                    <div class="text-muted" style="font-size:12px;">Order status: <?= h($r['order_status'] ?? '') ?></div>
                  </td>
                  <td>$<?= number_format((float)($r['total'] ?? 0), 2) ?></td>
                  <td>
                    <span class="badge bg-<?= $uwStatus==='approved'?'success':($uwStatus==='denied'?'danger':($uwStatus==='conditional'?'warning':'secondary')) ?>">
                      <?= h(strtoupper($uwStatus)) ?>
                    </span>
                  </td>
                  <td>
                    <span class="badge bg-<?= $risk>=55?'danger':($risk>=30?'warning':'success') ?>"><?= $risk ?>/100</span>
                  </td>
                  <td class="text-muted" style="font-size:12px;"><?= h($r['uw_updated'] ?? '') ?></td>
                  <td class="text-end">
                    <a class="btn btn-sm btn-outline-light" href="<?= app_path('underwriting/view.php?order_id='.(int)$r['id']) ?>">
                      <i class="fa-solid fa-arrow-right"></i> Open
                    </a>
                  </td>
                </tr>
              <?php endforeach; endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
