<?php
// /app/underwriting/actions/upload_id.php
declare(strict_types=1);

require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/scope.php';
require_once __DIR__ . '/../_uw.php';

require_company_context_if_rto();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header('Location: ' . app_path('underwriting/index.php'));
  exit;
}

if (!csrf_validate((string)($_POST['_csrf'] ?? ''))) {
  http_response_code(403);
  echo 'CSRF validation failed.';
  exit;
}

$pdo = db();
$tenantId = uw_company_tid();
$orderId = (int)($_POST['order_id'] ?? 0);
if ($orderId <= 0) {
  header('Location: ' . app_path('underwriting/index.php'));
  exit;
}

$case = uw_ensure_case($pdo, $tenantId, $orderId);
$caseId = (int)$case['id'];

try {
  $front = bunny_require_uploaded_image('id_front');
  $keyFront = 'underwriting/' . $tenantId . '/' . $orderId . '/id_front_' . bin2hex(random_bytes(6)) . '.' . $front['ext'];
  $upFront = bunny_upload_file($keyFront, $front['tmp']);

  // store doc
  $pdo->prepare('INSERT INTO underwriting_documents (case_id, doc_type, url, mime, bytes) VALUES (:cid,\'id_front\',:url,:mime,:b)
    ON DUPLICATE KEY UPDATE url=VALUES(url), mime=VALUES(mime), bytes=VALUES(bytes)')
    ->execute([':cid'=>$caseId, ':url'=>$upFront['public_url'], ':mime'=>$upFront['content_type'], ':b'=>$upFront['bytes']]);

  if (!empty($_FILES['id_back']) && (int)($_FILES['id_back']['error'] ?? UPLOAD_ERR_NO_FILE) === UPLOAD_ERR_OK) {
    $back = bunny_require_uploaded_image('id_back');
    $keyBack = 'underwriting/' . $tenantId . '/' . $orderId . '/id_back_' . bin2hex(random_bytes(6)) . '.' . $back['ext'];
    $upBack = bunny_upload_file($keyBack, $back['tmp']);

    $pdo->prepare('INSERT INTO underwriting_documents (case_id, doc_type, url, mime, bytes) VALUES (:cid,\'id_back\',:url,:mime,:b)
      ON DUPLICATE KEY UPDATE url=VALUES(url), mime=VALUES(mime), bytes=VALUES(bytes)')
      ->execute([':cid'=>$caseId, ':url'=>$upBack['public_url'], ':mime'=>$upBack['content_type'], ':b'=>$upBack['bytes']]);
  }

  uw_set_step($pdo, $caseId, 'id_ai', 'review', 10, ['message' => 'ID image(s) uploaded. Run AI verification.'], uw_user_id());
  uw_recompute_case_risk($pdo, $caseId);

} catch (Throwable $e) {
  uw_set_step($pdo, $caseId, 'id_ai', 'review', 25, ['error' => $e->getMessage()], uw_user_id());
  uw_recompute_case_risk($pdo, $caseId);
}

header('Location: ' . app_path('underwriting/view.php?order_id=' . $orderId));
exit;
