<?php
// /app/underwriting/actions/decide.php
declare(strict_types=1);

require_once __DIR__ . '/../../includes/auth.php';
require_once __DIR__ . '/../../includes/scope.php';
require_once __DIR__ . '/../_uw.php';

require_company_context_if_rto();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header('Location: ' . app_path('underwriting/index.php'));
  exit;
}

if (!csrf_validate((string)($_POST['_csrf'] ?? ''))) {
  http_response_code(403);
  echo 'CSRF validation failed.';
  exit;
}

$pdo = db();
$tenantId = uw_company_tid();
$orderId = (int)($_POST['order_id'] ?? 0);
$decision = (string)($_POST['decision'] ?? 'open');
$reason = trim((string)($_POST['reason'] ?? ''));

if ($orderId <= 0) {
  header('Location: ' . app_path('underwriting/index.php'));
  exit;
}

$case = uw_ensure_case($pdo, $tenantId, $orderId);
$caseId = (int)$case['id'];

if (!in_array($decision, ['approved','conditional','denied'], true)) {
  $decision = 'open';
}

$pdo->prepare('UPDATE underwriting_cases SET status=:st, decision_reason=:rs, decision_by_user_id=:uid, decision_at=NOW(), updated_at=NOW() WHERE id=:id')
  ->execute([':st'=>$decision, ':rs'=>$reason, ':uid'=>uw_user_id(), ':id'=>$caseId]);

if ($reason !== '') {
  uw_add_note($pdo, $caseId, uw_user_id(), '[decision] ' . strtoupper($decision) . '  -  ' . $reason);
}

header('Location: ' . app_path('underwriting/view.php?order_id=' . $orderId));
exit;
