<?php
// /app/repairs/repair_item_update.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_company_context_if_rto();

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header('Location: ' . app_path('repairs/repairs_list.php'));
  exit;
}

if (!csrf_validate((string)($_POST['_csrf'] ?? ''))) {
  http_response_code(403);
  echo 'CSRF validation failed.';
  exit;
}

$repairId = (int)($_POST['repair_id'] ?? 0);
$itemId = (int)($_POST['item_id'] ?? 0);

$category = trim((string)($_POST['category'] ?? ''));
$description = trim((string)($_POST['description'] ?? ''));
$estimated = $_POST['estimated_cost'] ?? null;
$actual = $_POST['actual_cost'] ?? null;

if ($repairId < 1 || $itemId < 1 || $description === '') {
  header('Location: ' . app_path('repairs/repair_view.php?id=' . $repairId));
  exit;
}

$estVal = ($estimated === '' || $estimated === null) ? null : (float)$estimated;
$actVal = ($actual === '' || $actual === null) ? null : (float)$actual;

$pdo = db();

$tenantType = current_tenant_type();
$rtoTenantId = (int) current_tenant_id();
$companyTenantId = ($tenantType === 'rto')
  ? (int) active_company_tenant_id()
  : (int) current_tenant_id();

try {
  // Ensure repair visibility
  $where = "tenant_id = :tid AND id = :rid";
  $params = [':tid' => $companyTenantId, ':rid' => $repairId];

  if ($tenantType === 'rto') {
    $where .= " AND rto_tenant_id = :rto";
    $params[':rto'] = $rtoTenantId;
  }

  $stmt = $pdo->prepare("SELECT id FROM repairs WHERE $where LIMIT 1");
  $stmt->execute($params);
  if (!$stmt->fetchColumn()) {
    http_response_code(403);
    echo 'Not authorized.';
    exit;
  }

  $stmt = $pdo->prepare("
    UPDATE repair_items
    SET category = :cat,
        description = :descr,
        estimated_cost = :est,
        actual_cost = :act
    WHERE tenant_id = :tid AND repair_id = :rid AND id = :iid
    LIMIT 1
  ");
  $stmt->execute([
    ':cat' => ($category === '' ? null : $category),
    ':descr' => $description,
    ':est' => $estVal,
    ':act' => $actVal,
    ':tid' => $companyTenantId,
    ':rid' => $repairId,
    ':iid' => $itemId,
  ]);

  header('Location: ' . app_path('repairs/repair_view.php?id=' . $repairId . '&ok=1'));
  exit;

} catch (Throwable $e) {
  http_response_code(500);
  echo 'Failed to update item. ' . htmlspecialchars($e->getMessage());
}
