<?php
// /app/operations/services.php
declare(strict_types=1);



require_once __DIR__ . '/_bootstrap.php';
require_once __DIR__ . '/includes/bootstrap.php';
require_once __DIR__ . '/_lib.php';

$pageTitle = 'Services';
$activeNav = 'operations';

$companyId = ops_require_company_scope();
if (!ops_can_configure()) { http_response_code(403); exit('Forbidden'); }

$pdo = db_safe();

$services = $pdo->prepare("SELECT * FROM ops_services WHERE company_id=:cid ORDER BY is_active DESC, service_name ASC");
$services->execute([':cid'=>$companyId]);
$services = $services->fetchAll(PDO::FETCH_ASSOC);

$keys = [];
if (ops_can_webhooks()) {
  $k = $pdo->prepare("SELECT * FROM ops_webhook_keys WHERE company_id=:cid ORDER BY is_enabled DESC, created_at DESC");
  $k->execute([':cid'=>$companyId]);
  $keys = $k->fetchAll(PDO::FETCH_ASSOC);
}

require_once __DIR__ . '/../includes/header.php';
$activeOps = 'services';
require __DIR__ . '/_subnav.php';
?>
<div class="row g-3">
  <div class="col-12 col-lg-7">
    <div class="card shadow-sm">
      <div class="card-header bg-dark text-white d-flex justify-content-between">
        <strong>Services</strong>
        <a class="btn btn-sm btn-primary" href="/app/operations/service_edit.php?id=new">Add Service</a>
      </div>
      <div class="card-body">
        <?php if (!$services): ?>
          <div class="text-muted">No services configured yet.</div>
        <?php else: ?>
          <div class="table-responsive">
            <table class="table table-sm table-striped align-middle">
              <thead class="table-dark">
                <tr>
                  <th>Name</th>
                  <th>Code</th>
                  <th>Defaults</th>
                  <th>Active</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($services as $s): ?>
                  <tr>
                    <td class="fw-semibold"><?=h((string)$s['service_name'])?></td>
                    <td><code><?=h((string)$s['service_code'])?></code></td>
                    <td class="small text-muted">
                      Priority <?= (int)$s['default_priority'] ?> · Due <?= (int)$s['default_due_days'] ?> days
                    </td>
                    <td><?= ((int)$s['is_active']===1) ? '<span class="badge bg-success">Yes</span>' : '<span class="badge bg-secondary">No</span>' ?></td>
                    <td class="text-end">
                      <a class="btn btn-sm btn-outline-primary" href="/app/operations/service_edit.php?id=<?= (int)$s['id'] ?>">Edit</a>
                    </td>
                  </tr>
                <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-5">
    <div class="card shadow-sm">
      <div class="card-header bg-dark text-white"><strong>Webhook Keys (ShedSuite)</strong></div>
      <div class="card-body">
        <div class="small text-muted mb-2">
          Use one key per company integration. ShedSuite should send it in header
          <code>X-ShedOffice-Webhook-Key</code> (preferred) or as <code>?key=</code> query string.
        </div>

        <?php if (!ops_can_webhooks()): ?>
          <div class="text-muted">You do not have permission to manage webhook keys.</div>
        <?php else: ?>
          <form method="post" action="/app/operations/webhook_key_save.php" class="d-flex gap-2 mb-3">
            <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
            <input class="form-control form-control-sm" name="label" placeholder="Key label (e.g., ShedSuite - TN Lot)" required>
            <button class="btn btn-sm btn-primary" type="submit">Create Key</button>
          </form>

          <?php if (!$keys): ?>
            <div class="text-muted">No keys created.</div>
          <?php else: ?>
            <div class="table-responsive">
              <table class="table table-sm align-middle">
                <thead>
                  <tr>
                    <th>Label</th>
                    <th>Key</th>
                    <th>Enabled</th>
                    <th></th>
                  </tr>
                </thead>
                <tbody>
                  <?php foreach ($keys as $k): ?>
                    <tr>
                      <td><?=h((string)$k['label'])?></td>
                      <td><code><?=h((string)$k['api_key'])?></code></td>
                      <td><?= ((int)$k['is_enabled']===1) ? '<span class="badge bg-success">Yes</span>' : '<span class="badge bg-secondary">No</span>' ?></td>
                      <td class="text-end">
                        <form method="post" action="/app/operations/webhook_key_save.php" class="d-inline">
                          <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
                          <input type="hidden" name="id" value="<?= (int)$k['id'] ?>">
                          <input type="hidden" name="toggle" value="1">
                          <button class="btn btn-sm btn-outline-dark" type="submit">
                            <?= ((int)$k['is_enabled']===1) ? 'Disable' : 'Enable' ?>
                          </button>
                        </form>
                      </td>
                    </tr>
                    <?php if (!empty($k['last_used_at'])): ?>
                      <tr class="small text-muted">
                        <td colspan="4">
                          Last used: <?=h((string)$k['last_used_at'])?><?= !empty($k['last_used_ip']) ? ' · IP '.h((string)$k['last_used_ip']) : '' ?>
                        </td>
                      </tr>
                    <?php endif; ?>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          <?php endif; ?>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
