<?php
// /app/operations/index.php
declare(strict_types=1);

require_once __DIR__ . '/_lib.php';

if (!ops_can_view()) { http_response_code(403); exit('Forbidden'); }

$pageTitle = 'Operations';
$activeNav = 'operations';
$activeOps = 'overview';

$pdo = db_safe();
$companyId = ops_require_company_scope();

$counts = [
  'new' => 0, 'scheduled' => 0, 'in_progress' => 0, 'blocked' => 0, 'completed' => 0, 'canceled' => 0,
];

$stmt = $pdo->prepare("
  SELECT status, COUNT(*) AS c
  FROM ops_work_orders
  WHERE company_id = :cid
  GROUP BY status
");
$stmt->execute([':cid' => $companyId]);
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $r) {
  $st = (string)$r['status'];
  if (isset($counts[$st])) $counts[$st] = (int)$r['c'];
}

$openTotal = $counts['new'] + $counts['scheduled'] + $counts['in_progress'] + $counts['blocked'];

require_once __DIR__ . '/../includes/header.php';
require_once __DIR__ . '/_subnav.php';
?>
<div class="container-fluid">
  <div class="row">
    <div class="col-12">
      <div class="so-page-title">Work Order Overview</div>
      <div class="so-page-sub">Quick snapshot of your operations queue.</div>
    </div>
  </div>

  <div class="row g-3 mb-3">
    <div class="col-12 col-md-6 col-xl-3">
      <div class="so-card so-stat">
        <div class="so-stat-ico"><i class="fa-solid fa-inbox"></i></div>
        <div class="flex-grow-1">
          <h6 class="so-stat-title mb-0">New</h6>
          <div class="so-stat-line">Unassigned / just created</div>
          <div class="so-stat-value"><?= (int)$counts['new'] ?></div>
          <div class="so-stat-meta">Needs triage</div>
        </div>
      </div>
    </div>

    <div class="col-12 col-md-6 col-xl-3">
      <div class="so-card so-stat">
        <div class="so-stat-ico"><i class="fa-solid fa-calendar-check"></i></div>
        <div class="flex-grow-1">
          <h6 class="so-stat-title mb-0">Scheduled</h6>
          <div class="so-stat-line">On the calendar</div>
          <div class="so-stat-value"><?= (int)$counts['scheduled'] ?></div>
          <div class="so-stat-meta">Upcoming installs</div>
        </div>
      </div>
    </div>

    <div class="col-12 col-md-6 col-xl-3">
      <div class="so-card so-stat">
        <div class="so-stat-ico"><i class="fa-solid fa-person-digging"></i></div>
        <div class="flex-grow-1">
          <h6 class="so-stat-title mb-0">In Progress</h6>
          <div class="so-stat-line">Actively being worked</div>
          <div class="so-stat-value"><?= (int)$counts['in_progress'] ?></div>
          <div class="so-stat-meta">Technicians engaged</div>
        </div>
      </div>
    </div>

    <div class="col-12 col-md-6 col-xl-3">
      <div class="so-card so-stat">
        <div class="so-stat-ico"><i class="fa-solid fa-triangle-exclamation"></i></div>
        <div class="flex-grow-1">
          <h6 class="so-stat-title mb-0">Blocked</h6>
          <div class="so-stat-line">Waiting on something</div>
          <div class="so-stat-value"><?= (int)$counts['blocked'] ?></div>
          <div class="so-stat-meta">Remove constraints</div>
        </div>
      </div>
    </div>
  </div>

  <div class="row g-3 mb-3">
    <div class="col-12 col-xl-6">
      <div class="so-card">
        <div class="so-card-h">
          <h5 class="so-card-title">
            <i class="fa-solid fa-clipboard-list me-2" style="color:#cf1f1f"></i>Queue Summary
          </h5>
          <a class="so-btn btn btn-sm" href="<?= h(app_path('operations/workorders_list.php')) ?>">View All</a>
        </div>
        <div class="so-card-body">
          <div class="table-responsive">
            <table class="table so-table align-middle">
              <thead>
                <tr>
                  <th>Status</th>
                  <th class="text-end">Count</th>
                </tr>
              </thead>
              <tbody>
                <tr><td><span class="so-pill gray">New</span></td><td class="text-end"><strong><?= (int)$counts['new'] ?></strong></td></tr>
                <tr><td><span class="so-pill blue">Scheduled</span></td><td class="text-end"><strong><?= (int)$counts['scheduled'] ?></strong></td></tr>
                <tr><td><span class="so-pill orange">In Progress</span></td><td class="text-end"><strong><?= (int)$counts['in_progress'] ?></strong></td></tr>
                <tr><td><span class="so-pill red">Blocked</span></td><td class="text-end"><strong><?= (int)$counts['blocked'] ?></strong></td></tr>
                <tr><td><span class="so-pill blue">Completed</span></td><td class="text-end"><strong><?= (int)$counts['completed'] ?></strong></td></tr>
                <tr><td><span class="so-pill gray">Canceled</span></td><td class="text-end"><strong><?= (int)$counts['canceled'] ?></strong></td></tr>
              </tbody>
            </table>
          </div>

          <div class="text-muted small mt-2">
            Open (New + Scheduled + In Progress + Blocked): <strong><?= (int)$openTotal ?></strong>
          </div>
        </div>
      </div>
    </div>

    <div class="col-12 col-xl-6">
      <div class="so-card">
        <div class="so-card-h">
          <h5 class="so-card-title">
            <i class="fa-solid fa-circle-check me-2" style="color:#cf1f1f"></i>Completed
          </h5>
          <a class="so-btn btn btn-sm" href="<?= h(app_path('operations/workorders_list.php?status=completed')) ?>">View</a>
        </div>
        <div class="so-card-body">
          <div class="d-flex align-items-center justify-content-between">
            <div class="text-muted">Completed work orders</div>
            <div class="so-stat-value mb-0" style="font-size:34px;"><?= (int)$counts['completed'] ?></div>
          </div>
          <div class="text-muted small mt-2">Canceled: <strong><?= (int)$counts['canceled'] ?></strong></div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
