<?php
// /app/operations/_subnav.php
declare(strict_types=1);

$activeOps = $activeOps ?? 'overview';

$items = [
  'overview'   => ['label' => 'Overview',    'href' => app_path('operations/index.php'),           'icon' => 'fa-gauge-high'],
  'workorders' => ['label' => 'Work Orders', 'href' => app_path('operations/workorders_list.php'), 'icon' => 'fa-clipboard-list'],
  'services'   => ['label' => 'Services',    'href' => app_path('operations/services.php'),        'icon' => 'fa-layer-group'],
  'mapping'    => ['label' => 'Add-on Map',  'href' => app_path('operations/addon_mapping.php'),   'icon' => 'fa-code-branch'],
];

?>
<div class="so-card mb-3">
  <div class="so-card-h">
    <h5 class="so-card-title">
      <i class="fa-solid fa-sitemap me-2" style="color:#cf1f1f"></i>Operations
    </h5>
    <div class="d-flex gap-2">
      <a class="so-btn btn btn-sm" href="<?= h(app_path('operations/workorder_view.php?id=new')) ?>">
        <i class="fa-solid fa-plus me-2"></i>New Work Order
      </a>
    </div>
  </div>
  <div class="so-card-body pt-2">
    <div class="d-flex flex-wrap gap-2">
      <?php foreach ($items as $key => $it): ?>
        <a
          class="so-btn btn btn-sm"
          href="<?= h($it['href']) ?>"
          style="<?= $activeOps === $key ? '' : 'border-color:rgba(18,20,24,0.10);background:#fff;color:#111827;' ?>"
        >
          <i class="fa-solid <?= h($it['icon']) ?> me-2" style="<?= $activeOps === $key ? 'color:#cf1f1f' : 'color:#64748b' ?>"></i>
          <?= h($it['label']) ?>
        </a>
      <?php endforeach; ?>
    </div>
  </div>
</div>
