<?php
// /app/gps/gps_unassign.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_company_context_if_rto();

require_once __DIR__ . '/../includes/acl.php';
require_once __DIR__ . '/../includes/scope.php';

$pdo = db();
acl_bootstrap($pdo);

$isCompanyAdmin = user_has_role('company_admin');
$isManager      = user_has_role('manager');

if (!($isCompanyAdmin || $isManager || user_can('gps.manage'))) {
  http_response_code(403);
  exit('Forbidden');
}

if (!csrf_validate((string)($_POST['_csrf'] ?? ''))) {
  http_response_code(403);
  exit('CSRF failed');
}

$tenantId = company_context_id();
$gpsDeviceId = (int)($_POST['gps_device_id'] ?? 0);

if ($gpsDeviceId <= 0) {
  http_response_code(400);
  exit('Missing gps_device_id');
}

// Close active assignment (if any)
$pdo->prepare("
  UPDATE gps_assignments
     SET unassigned_at = NOW()
   WHERE tenant_id = :tid
     AND gps_device_id = :did
     AND unassigned_at IS NULL
")->execute([
  ':tid' => $tenantId,
  ':did' => $gpsDeviceId,
]);

// Redirect back to the device edit page (matches gps_assign.php behavior)
header('Location: ' . app_path('gps/gps_edit.php?id=' . $gpsDeviceId));
exit;
