<?php
// /app/gps/gps_save.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_company_context_if_rto();

require_once __DIR__ . '/../includes/acl.php';
require_once __DIR__ . '/../includes/scope.php';

$pdo = db();
acl_bootstrap($pdo);

$isCompanyAdmin = user_has_role('company_admin');
$isManager      = user_has_role('manager');
if (!($isCompanyAdmin || $isManager || user_can('gps.manage'))) {
  http_response_code(403);
  exit('Forbidden');
}

if (!csrf_validate((string)($_POST['_csrf'] ?? ''))) {
  http_response_code(403);
  exit('CSRF failed');
}

$tenantId = company_context_id();
$id = (int)($_POST['id'] ?? 0);

$deviceName = trim((string)($_POST['device_name'] ?? ''));
$provider   = trim((string)($_POST['provider'] ?? ''));
$provId     = trim((string)($_POST['provider_device_id'] ?? ''));
$status     = trim((string)($_POST['status'] ?? 'active'));
if ($deviceName === '') { http_response_code(400); exit('Device name required'); }

$allowedStatus = ['active','inactive','suspended','lost'];
if (!in_array($status, $allowedStatus, true)) $status = 'active';

if ($id <= 0) {
  $ins = $pdo->prepare("
    INSERT INTO gps_devices
      (tenant_id, device_name, provider, provider_device_id, status, created_at, updated_at)
    VALUES
      (:tid, :name, :prov, :pid, :status, NOW(), NOW())
  ");
  $ins->execute([
    ':tid'=>$tenantId,
    ':name'=>$deviceName,
    ':prov'=>$provider ?: null,
    ':pid'=>$provId ?: null,
    ':status'=>$status,
  ]);

  header('Location: ' . app_path('gps/gps_list.php'));
  exit;
}

$upd = $pdo->prepare("
  UPDATE gps_devices
     SET device_name=:name,
         provider=:prov,
         provider_device_id=:pid,
         status=:status,
         updated_at=NOW()
   WHERE id=:id AND tenant_id=:tid
");
$upd->execute([
  ':name'=>$deviceName,
  ':prov'=>$provider ?: null,
  ':pid'=>$provId ?: null,
  ':status'=>$status,
  ':id'=>$id,
  ':tid'=>$tenantId,
]);

header('Location: ' . app_path('gps/gps_edit.php?id=' . $id));
exit;
