<?php
// /app/gps/gps_lookup.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_company_context_if_rto();

require_once __DIR__ . '/../includes/acl.php';
require_once __DIR__ . '/../includes/scope.php';
require_once __DIR__ . '/../includes/db.php';

$pdo = db();
acl_bootstrap($pdo);

$isCompanyAdmin = user_has_role('company_admin');
$isManager      = user_has_role('manager');
if (!($isCompanyAdmin || $isManager || user_can('gps.view'))) {
  http_response_code(403);
  header('Content-Type: application/json');
  echo json_encode(['ok'=>false,'msg'=>'Forbidden']);
  exit;
}

$tenantId = company_context_id();

$sql = "
SELECT
  d.id,
  d.device_name,
  d.status,
  a.asset_id,
  p.lat,
  p.lng,
  p.speed_mph,
  p.heading_deg,
  p.pinged_at
FROM gps_devices d
LEFT JOIN gps_assignments a
  ON a.tenant_id=d.tenant_id
 AND a.gps_device_id=d.id
 AND a.unassigned_at IS NULL
LEFT JOIN gps_pings p
  ON p.tenant_id=d.tenant_id
 AND p.gps_device_id=d.id
 AND p.pinged_at = (
   SELECT MAX(p2.pinged_at)
   FROM gps_pings p2
   WHERE p2.tenant_id=d.tenant_id AND p2.gps_device_id=d.id
 )
WHERE d.tenant_id=:tid
ORDER BY d.id DESC
";
$stmt = $pdo->prepare($sql);
$stmt->execute([':tid'=>$tenantId]);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);

header('Content-Type: application/json; charset=utf-8');
echo json_encode(['ok'=>true,'items'=>$items], JSON_UNESCAPED_SLASHES);
