<?php
// /app/gps/gps_assign.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_company_context_if_rto();

require_once __DIR__ . '/../includes/acl.php';
require_once __DIR__ . '/../includes/scope.php';

$pdo = db();
acl_bootstrap($pdo);

$isCompanyAdmin = user_has_role('company_admin');
$isManager      = user_has_role('manager');
if (!($isCompanyAdmin || $isManager || user_can('gps.manage'))) {
  http_response_code(403);
  exit('Forbidden');
}

if (!csrf_validate((string)($_POST['_csrf'] ?? ''))) {
  http_response_code(403);
  exit('CSRF failed');
}

$tenantId = company_context_id();
$gpsDeviceId = (int)($_POST['gps_device_id'] ?? 0);
$assetId = trim((string)($_POST['asset_id'] ?? ''));

if ($gpsDeviceId <= 0 || $assetId === '') {
  http_response_code(400);
  exit('Missing data');
}

// Close any previous assignment
$pdo->prepare("
  UPDATE gps_assignments
     SET unassigned_at = NOW()
   WHERE tenant_id=:tid AND gps_device_id=:did AND unassigned_at IS NULL
")->execute([':tid'=>$tenantId, ':did'=>$gpsDeviceId]);

// Create assignment (asset_id column is likely numeric; but you didn’t specify type. Insert as-is.)
$pdo->prepare("
  INSERT INTO gps_assignments
    (tenant_id, gps_device_id, asset_id, assigned_by_user_id, assigned_at, unassigned_at)
  VALUES
    (:tid, :did, :aid, :uid, NOW(), NULL)
")->execute([
  ':tid'=>$tenantId,
  ':did'=>$gpsDeviceId,
  ':aid'=>$assetId,
  ':uid'=>current_user_id(),
]);

header('Location: ' . app_path('gps/gps_edit.php?id=' . $gpsDeviceId));
exit;
