<?php
// /app/gps/gps_add.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_company_context_if_rto();

require_once __DIR__ . '/../includes/acl.php';
require_once __DIR__ . '/../includes/scope.php';

$pageTitle = 'GPS · Add Device';
$activeNav = 'gps';

$pdo = db();
acl_bootstrap($pdo);

$isCompanyAdmin = user_has_role('company_admin');
$isManager      = user_has_role('manager');
if (!($isCompanyAdmin || $isManager || user_can('gps.manage'))) {
  http_response_code(403);
  exit('Forbidden');
}

require_once __DIR__ . '/../includes/header.php';
?>
<div class="container-fluid">
  <div class="row">
    <div class="col-12">
      <div class="so-page-title">Add GPS Device</div>
      <div class="so-page-sub">Create a device record. Pings are ingested separately.</div>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-12 col-xl-8">
      <div class="so-card">
        <div class="so-card-h">
          <h5 class="so-card-title"><i class="fa-solid fa-plus me-2" style="color:#cf1f1f"></i>Device</h5>
          <a class="so-btn btn btn-sm" href="<?= app_path('gps/gps_list.php') ?>"><i class="fa-solid fa-arrow-left me-2"></i>Back</a>
        </div>
        <div class="so-card-body">
          <form method="post" action="<?= app_path('gps/gps_save.php') ?>" class="row g-2">
            <input type="hidden" name="_csrf" value="<?= h(csrf_token()) ?>">
            <input type="hidden" name="id" value="0">

            <div class="col-12 col-md-6">
              <label class="form-label small text-muted mb-1">Device Name</label>
              <input class="form-control" name="device_name" required placeholder="e.g., GPS-Unit-12">
            </div>

            <div class="col-12 col-md-3">
              <label class="form-label small text-muted mb-1">Provider</label>
              <input class="form-control" name="provider" placeholder="e.g., Spot, Samsara, LandAirSea">
            </div>

            <div class="col-12 col-md-3">
              <label class="form-label small text-muted mb-1">Provider Device ID</label>
              <input class="form-control" name="provider_device_id" placeholder="Provider identifier">
            </div>

            <div class="col-12 col-md-4">
              <label class="form-label small text-muted mb-1">Status</label>
              <select class="form-select" name="status">
                <option value="active">active</option>
                <option value="inactive">inactive</option>
                <option value="suspended">suspended</option>
                <option value="lost">lost</option>
              </select>
            </div>

            <div class="col-12">
              <button class="so-btn btn btn-sm" type="submit"><i class="fa-solid fa-floppy-disk me-2"></i>Save Device</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
