<?php
// /app/driver/index.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_login();

require_once __DIR__ . '/../includes/acl.php';

$pdo = db();
acl_bootstrap($pdo);

if (current_tenant_type() !== 'company') {
  http_response_code(403);
  echo "Driver mode is for company accounts only.";
  exit;
}

if (!user_has_role('driver')) {
  http_response_code(403);
  echo "Forbidden: driver role required.";
  exit;
}

header('Location: ' . app_path('driver/home.php'));
exit;
