<?php
// /app/deliveries/note_save.php
declare(strict_types=1);

require_once __DIR__ . '/_lib.php';
if (!d_can_manage()) { http_response_code(403); exit('Forbidden'); }

if (!csrf_validate((string)($_POST['_csrf'] ?? ''))) {
  http_response_code(403);
  exit('CSRF failed');
}

$tenantId = company_context_id();
$orderId = (int)($_POST['order_id'] ?? 0);
$note = trim((string)($_POST['note'] ?? ''));

if ($orderId <= 0 || $note === '') {
  header('Location: ' . app_path('deliveries/deliveries.php'));
  exit;
}

$userId = function_exists('current_user_id') ? (int)current_user_id() : null;

$pdo->prepare("
  INSERT INTO delivery_notes (tenant_id, order_id, user_id, note)
  VALUES (:tid, :oid, :uid, :note)
")->execute([
  ':tid'=>$tenantId, ':oid'=>$orderId, ':uid'=>$userId, ':note'=>$note
]);

header('Location: ' . app_path('deliveries/delivery_view.php?id=' . $orderId));
exit;
