<?php
// /app/deliveries/_lib.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_company_context_if_rto();

require_once __DIR__ . '/../includes/acl.php';
require_once __DIR__ . '/../includes/scope.php';
require_once __DIR__ . '/../includes/db.php';

$pdo = db();
acl_bootstrap($pdo);

function d_can_view(): bool {
  return user_has_role('company_admin') || user_has_role('manager') || user_can('deliveries.view');
}

function d_can_manage(): bool {
  return user_has_role('company_admin') || user_has_role('manager') || user_can('deliveries.manage');
}

function d_status_pill(string $st): array {
  $st = strtolower(trim($st));
  return match ($st) {
    'submitted' => ['blue', 'Submitted'],
    'processed' => ['orange', 'Processed'],
    'delivered' => ['blue', 'Delivered'],
    'canceled'  => ['gray', 'Canceled'],
    default     => ['gray', ($st !== '' ? $st : 'Unknown')],
  };
}

/**
 * ShedOffice users table does NOT have a `name` column.
 * Use first_name + last_name, then email, then id fallback.
 */
function d_user_display_name(array $u): string {
  $first = (string)($u['first_name'] ?? '');
  $last  = (string)($u['last_name'] ?? '');
  $nm = trim($first . ' ' . $last);
  if ($nm !== '') return $nm;

  $email = (string)($u['email'] ?? '');
  if ($email !== '') return $email;

  $id = (int)($u['id'] ?? 0);
  return $id > 0 ? ('User #' . $id) : 'User';
}

/**
 * Alias used across Deliveries pages.
 */
function d_driver_label(array $u): string {
  return d_user_display_name($u);
}
