<?php
// /dashboard.php
declare(strict_types=1);

require_once __DIR__ . '/includes/auth.php';
require_company_context_if_rto();

$pageTitle = 'Dashboard';
$activeNav = 'dashboard';
require_once __DIR__ . '/includes/header.php';


// Demo metrics (wire these to DB later)
$metrics = [
  'repos_in_progress' => 4,
  'repairs_pending' => 6,
  'gps_tracked' => 57,
  'open_contracts' => 64,
];
?>
<div class="container-fluid">
  <div class="row">
    <div class="col-12">
      <div class="so-page-title">Welcome, <?= htmlspecialchars(current_user()['name'] ?? 'User') ?>!</div>
      <div class="so-page-sub">Here’s an overview of what’s happening today:</div>
    </div>
  </div>

  <!-- TOP STAT CARDS -->
  <div class="row g-3 mb-3">
    <div class="col-12 col-md-6 col-xl-3">
      <div class="so-card so-stat">
        <div class="so-stat-ico"><i class="fa-solid fa-truck-ramp-box"></i></div>
        <div class="flex-grow-1">
          <h6 class="so-stat-title mb-0">Repos</h6>
          <div class="so-stat-line"><?= (int)$metrics['repos_in_progress'] ?> in progress</div>
          <div class="so-stat-value"><?= (int)$metrics['repos_in_progress'] ?></div>
          <div class="so-stat-meta"><span class="up">▲ 1</span> New today · 2 Completed</div>
        </div>
      </div>
    </div>

    <div class="col-12 col-md-6 col-xl-3">
      <div class="so-card so-stat">
        <div class="so-stat-ico"><i class="fa-solid fa-screwdriver-wrench"></i></div>
        <div class="flex-grow-1">
          <h6 class="so-stat-title mb-0">Repairs</h6>
          <div class="so-stat-line"><?= (int)$metrics['repairs_pending'] ?> pending</div>
          <div class="so-stat-value"><?= (int)$metrics['repairs_pending'] ?></div>
          <div class="so-stat-meta"><span class="up">▲ 2</span> Opened · 1 Completed</div>
        </div>
      </div>
    </div>

    <div class="col-12 col-md-6 col-xl-3">
      <div class="so-card so-stat">
        <div class="so-stat-ico"><i class="fa-solid fa-location-dot"></i></div>
        <div class="flex-grow-1">
          <h6 class="so-stat-title mb-0">GPS-Tracked Assets</h6>
          <div class="so-stat-line"><?= (int)$metrics['gps_tracked'] ?> tracked</div>
          <div class="so-stat-value"><?= (int)$metrics['gps_tracked'] ?></div>
          <div class="so-stat-meta"><span class="up">▲ 1</span> Newly tracked</div>
        </div>
      </div>
    </div>

    <div class="col-12 col-md-6 col-xl-3">
      <div class="so-card so-stat">
        <div class="so-stat-ico"><i class="fa-solid fa-clipboard-list"></i></div>
        <div class="flex-grow-1">
          <h6 class="so-stat-title mb-0">Open Contracts</h6>
          <div class="so-stat-line"><?= (int)$metrics['open_contracts'] ?> open</div>
          <div class="so-stat-value"><?= (int)$metrics['open_contracts'] ?></div>
          <div class="so-stat-meta"><span class="up">▲ 2</span> New · <span class="down">▼ 1</span> Closed</div>
        </div>
      </div>
    </div>
  </div>

  <!-- LOWER CARDS -->
  <div class="row g-3 mb-3">
    <!-- Active Repos -->
    <div class="col-12 col-xl-6">
      <div class="so-card">
        <div class="so-card-h">
          <h5 class="so-card-title"><i class="fa-solid fa-truck-ramp-box me-2" style="color:#cf1f1f"></i>Active Repos</h5>
          <a class="so-btn btn btn-sm" href="#">View All</a>
        </div>
        <div class="so-card-body">
          <div class="table-responsive">
            <table class="table so-table align-middle">
              <thead>
                <tr>
                  <th>RTO Company</th>
                  <th>Asset</th>
                  <th>Assigned Driver</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td><strong>ABC Financing</strong><div class="text-muted small">S: 1334860</div></td>
                  <td><strong>S1234568</strong><div class="text-muted small">10x16 Shed</div></td>
                  <td>Tom Driver</td>
                  <td class="text-end"><a href="#" class="text-muted"><i class="fa-solid fa-chevron-right"></i></a></td>
                </tr>
                <tr>
                  <td><strong>XYZ Rentals</strong><div class="text-muted small">S: 2236763</div></td>
                  <td><strong>S9878542</strong><div class="text-muted small">12x20 Shed</div></td>
                  <td>Jake Driver</td>
                  <td class="text-end"><a href="#" class="text-muted"><i class="fa-solid fa-chevron-right"></i></a></td>
                </tr>
                <tr>
                  <td><strong>Prime Leasing</strong><div class="text-muted small">S: 2541731</div></td>
                  <td><strong>S7654321</strong><div class="text-muted small">14x24 Cabin</div></td>
                  <td>Mike Worker</td>
                  <td class="text-end"><a href="#" class="text-muted"><i class="fa-solid fa-chevron-right"></i></a></td>
                </tr>
                <tr>
                  <td><strong>XYZ Rentals</strong><div class="text-muted small">S: 1234763</div></td>
                  <td><strong>S3456799</strong><div class="text-muted small">10x12 Shed</div></td>
                  <td>Jake Driver</td>
                  <td class="text-end"><a href="#" class="text-muted"><i class="fa-solid fa-chevron-right"></i></a></td>
                </tr>
                <tr>
                  <td><strong>ABC Financing</strong><div class="text-muted small">S: 3346811</div></td>
                  <td><strong>S2345581</strong><div class="text-muted small">12x24 Shed</div></td>
                  <td>Ryan York</td>
                  <td class="text-end"><a href="#" class="text-muted"><i class="fa-solid fa-chevron-right"></i></a></td>
                </tr>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>

    <!-- Pending Repairs -->
    <div class="col-12 col-xl-6">
      <div class="so-card">
        <div class="so-card-h">
          <h5 class="so-card-title"><i class="fa-solid fa-screwdriver-wrench me-2" style="color:#cf1f1f"></i>Pending Repairs</h5>
          <a class="so-btn btn btn-sm" href="#">View All</a>
        </div>
        <div class="so-card-body">
          <div class="table-responsive">
            <table class="table so-table align-middle">
              <thead>
                <tr>
                  <th>Stock # / Asset</th>
                  <th>Assigned Tech</th>
                  <th>Location</th>
                  <th class="text-end">Priority</th>
                </tr>
              </thead>
              <tbody>
                <tr>
                  <td><strong>S654321</strong><div class="text-muted small">10x16 Shed</div></td>
                  <td>Tim Prait</td>
                  <td>Springfield</td>
                  <td class="text-end"><span class="so-pill red">High</span></td>
                </tr>
                <tr>
                  <td><strong>S098765</strong><div class="text-muted small">10x10 Shed</div></td>
                  <td>Rob Repair</td>
                  <td>Anderson, IN</td>
                  <td class="text-end"><span class="so-pill orange">Medium</span></td>
                </tr>
                <tr>
                  <td><strong>S223344</strong><div class="text-muted small">14x24 Cabin</div></td>
                  <td>—</td>
                  <td>Louisville, KY</td>
                  <td class="text-end"><span class="so-pill blue">Low</span></td>
                </tr>
                <tr>
                  <td><strong>S545210</strong><div class="text-muted small">14x24 Shed</div></td>
                  <td>Steve Builder</td>
                  <td>Louisville, KY</td>
                  <td class="text-end"><span class="so-pill red">High</span></td>
                </tr>
                <tr>
                  <td><strong>S387630</strong><div class="text-muted small">8x16 Shed</div></td>
                  <td>Bob Worker</td>
                  <td>Lot #32</td>
                  <td class="text-end"><span class="so-pill blue">Low</span></td>
                </tr>
              </tbody>
            </table>
          </div>

        </div>
      </div>
    </div>
  </div>

  <!-- MAP OVERVIEW -->
  <div class="row g-3">
    <div class="col-12">
      <div class="so-card">
        <div class="so-card-h">
          <div>
            <h5 class="so-card-title mb-0"><i class="fa-solid fa-map-location-dot me-2" style="color:#cf1f1f"></i>Map Overview</h5>
            <div class="text-muted small mt-1">View the latest repo locations and activity.</div>
          </div>
          <a class="so-btn btn btn-sm" href="#">View All</a>
        </div>
        <div class="so-card-body">
          <div id="repoMap" class="so-map"></div>
        </div>
      </div>
    </div>
  </div>

</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
