<?php
// /app/admin/settings.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_login();

require_once __DIR__ . '/../includes/acl.php';

$pageTitle = 'Settings';
$activeNav = 'settings';

$pdo = db();
acl_bootstrap($pdo);

$tenantType = current_tenant_type();
if ($tenantType === 'rto') {
  http_response_code(403);
  echo "RTO accounts cannot access company settings.";
  exit;
}

$isCompanyAdmin = user_has_role('company_admin');
$isManager = user_has_role('manager');

if (!$isCompanyAdmin && !$isManager) {
  http_response_code(403);
  echo "Only admin/manager can access settings.";
  exit;
}

require_once __DIR__ . '/../includes/header.php';
?>
<div class="container-fluid">

  <div class="d-flex flex-wrap justify-content-between align-items-end gap-2 mb-3">
    <div>
      <div class="so-page-title">Settings</div>
      <div class="so-page-sub">Manage configuration for billing, fees, users, and operational policies.</div>
    </div>
  </div>

  <div class="row g-3">

    <!-- Repo Fees & Billing -->
    <div class="col-12 col-lg-6 col-xxl-4">
      <div class="so-card h-100">
        <div class="so-card-h">
          <h5 class="so-card-title">
            <i class="fa-solid fa-receipt me-2" style="color:#cf1f1f"></i>
            Repo Fees & Billing
          </h5>
        </div>
        <div class="so-card-body">
          <div class="text-muted mb-3">
            Configure repo fee schedules, width rules, mileage, add-on fees, invoice billing target, and driver override policies.
          </div>
          <a class="btn btn-dark" style="border-radius:12px;" href="<?= app_path('admin/repo_fee_settings.php') ?>">
            Open Repo Fee Settings <i class="fa-solid fa-arrow-right ms-2"></i>
          </a>
        </div>
      </div>
    </div>

    <!-- Users & Roles (placeholder until built) -->
    <div class="col-12 col-lg-6 col-xxl-4">
      <div class="so-card h-100">
        <div class="so-card-h">
          <h5 class="so-card-title">
            <i class="fa-solid fa-users me-2" style="color:#cf1f1f"></i>
            Users & Roles
          </h5>
        </div>
        <div class="so-card-body">
          <div class="text-muted mb-3">
            Manage user accounts, roles, permissions, and access policies (drivers, techs, managers, admins).
          </div>
          <a class="btn btn-outline-dark" style="border-radius:12px;" href="<?= app_path('admin/users_list.php') ?>">
            Open Users (placeholder) <i class="fa-solid fa-arrow-right ms-2"></i>
          </a>
          <div class="text-muted small mt-2">
            This page will be implemented next as we finalize role-based restrictions.
          </div>
        </div>
      </div>
    </div>

    <!-- Locations (placeholder until built) -->
    <div class="col-12 col-lg-6 col-xxl-4">
      <div class="so-card h-100">
        <div class="so-card-h">
          <h5 class="so-card-title">
            <i class="fa-solid fa-map-location-dot me-2" style="color:#cf1f1f"></i>
            Locations
          </h5>
        </div>
        <div class="so-card-body">
          <div class="text-muted mb-3">
            Manage company yard locations used for repo drop-offs and reporting.
          </div>
          <a class="btn btn-outline-dark" style="border-radius:12px;" href="<?= app_path('locations/locations_list.php') ?>">
            Open Locations (placeholder) <i class="fa-solid fa-arrow-right ms-2"></i>
          </a>
        </div>
      </div>
    </div>

    <!-- System / Security (placeholder) -->
    <div class="col-12 col-lg-6 col-xxl-4">
      <div class="so-card h-100">
        <div class="so-card-h">
          <h5 class="so-card-title">
            <i class="fa-solid fa-shield-halved me-2" style="color:#cf1f1f"></i>
            Security & Access Policies
          </h5>
        </div>
        <div class="so-card-body">
          <div class="text-muted mb-3">
            Configure password policies, session timeouts, MFA options, and audit logging policies.
          </div>
          <a class="btn btn-outline-dark" style="border-radius:12px;" href="#">
            Coming Soon <i class="fa-solid fa-lock ms-2"></i>
          </a>
        </div>
      </div>
    </div>

    <!-- Integrations (placeholder) -->
    <div class="col-12 col-lg-6 col-xxl-4">
      <div class="so-card h-100">
        <div class="so-card-h">
          <h5 class="so-card-title">
            <i class="fa-solid fa-plug me-2" style="color:#cf1f1f"></i>
            Integrations
          </h5>
        </div>
        <div class="so-card-body">
          <div class="text-muted mb-3">
            Configure external services like GPS providers and file storage/CDN settings.
          </div>
          <a class="btn btn-outline-dark" style="border-radius:12px;" href="#">
            Coming Soon <i class="fa-solid fa-arrow-right ms-2"></i>
          </a>
        </div>
      </div>
    </div>

    <!-- Reporting Settings (placeholder) -->
    <div class="col-12 col-lg-6 col-xxl-4">
      <div class="so-card h-100">
        <div class="so-card-h">
          <h5 class="so-card-title">
            <i class="fa-solid fa-chart-line me-2" style="color:#cf1f1f"></i>
            Reporting & Exports
          </h5>
        </div>
        <div class="so-card-body">
          <div class="text-muted mb-3">
            Configure reporting defaults, invoice exports, and scheduled summaries.
          </div>
          <a class="btn btn-outline-dark" style="border-radius:12px;" href="#">
            Coming Soon <i class="fa-solid fa-arrow-right ms-2"></i>
          </a>
        </div>
      </div>
    </div>

  </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
