<?php
// /app/admin/repo_addon_save.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_login();
require_once __DIR__ . '/../includes/acl.php';

if (!csrf_validate((string)($_POST['_csrf'] ?? ''))) {
  http_response_code(403);
  echo 'CSRF validation failed.';
  exit;
}

$pdo = db();
acl_bootstrap($pdo);

$tenantType = current_tenant_type();
if ($tenantType === 'rto') { http_response_code(403); exit; }

$isCompanyAdmin = user_has_role('company_admin');
$isManager = user_has_role('manager');
if (!$isCompanyAdmin && !$isManager) { http_response_code(403); exit; }

$companyTenantId = (int) current_tenant_id();

$appliesTo = trim((string)($_POST['applies_to'] ?? 'company'));
if (!in_array($appliesTo, ['company','rto'], true)) $appliesTo = 'company';

$rtoTenantId = null;
$rt = (int)($_POST['rto_tenant_id'] ?? 0);
if ($appliesTo === 'rto' && $rt > 0) $rtoTenantId = $rt;

$name = trim((string)($_POST['name'] ?? ''));
$description = trim((string)($_POST['description'] ?? ''));

$defaultAmount = (float)($_POST['default_amount'] ?? 0);
$maxAmount = (float)($_POST['max_amount'] ?? 0);

$driverCanAdd = isset($_POST['driver_can_add']) ? 1 : 0;
$driverCanOverrideAmt = isset($_POST['driver_can_override_amount']) ? 1 : 0;
$isActive = isset($_POST['is_active']) ? 1 : 0;

if ($name === '' || $defaultAmount < 0 || $maxAmount < 0) {
  http_response_code(400);
  echo "Invalid add-on fields.";
  exit;
}

$stmt = $pdo->prepare("
  INSERT INTO repo_addon_fee_types
    (tenant_id, applies_to, rto_tenant_id, name, description, default_amount, max_amount,
     driver_can_add, driver_can_override_amount, is_active, created_at)
  VALUES
    (:tid1, :ap1, :rto1, :n1, :d1, :def1, :max1, :dadd1, :dovr1, :act1, CURRENT_TIMESTAMP)
");
$stmt->execute([
  ':tid1' => $companyTenantId,
  ':ap1' => $appliesTo,
  ':rto1' => $rtoTenantId,
  ':n1' => $name,
  ':d1' => ($description === '' ? null : $description),
  ':def1' => $defaultAmount,
  ':max1' => $maxAmount,
  ':dadd1' => $driverCanAdd,
  ':dovr1' => $driverCanOverrideAmt,
  ':act1' => $isActive,
]);

header('Location: ' . app_path('admin/repo_fee_settings.php?tab=addons&ok=1'));
exit;
