<?php
// /app/includes/header.php
declare(strict_types=1);

require_once __DIR__ . '/auth.php';
require_once __DIR__ . '/acl.php';

require_login();

// Bootstrap ACL (roles + permissions cached in session)
acl_bootstrap(db());

$user = current_user();
$pageTitle = $pageTitle ?? 'Dashboard';
$activeNav = $activeNav ?? 'dashboard';

// Convenience booleans
$isCompanyAdmin = user_has_role('company_admin');
$isManager      = user_has_role('manager');
$isDriver       = user_has_role('driver');
$isTech         = user_has_role('repair_tech');

// Driver mode: driver role AND not admin/manager
$isDriverMode = (current_tenant_type() === 'company') && $isDriver && !$isCompanyAdmin && !$isManager;

// Permission-based toggles (role-first, permission-second)
$canRepos    = $isCompanyAdmin || $isManager || user_can('repos.view');
$canRepairs  = $isCompanyAdmin || $isManager || user_can('repairs.view');
$canGPS      = $isCompanyAdmin || $isManager || user_can('gps.view');
$canLocs     = $isCompanyAdmin || $isManager || user_can('locations.view');
$canUsers    = $isCompanyAdmin || user_can('users.manage');
$canSettings = $isCompanyAdmin || user_can('settings.manage');

// New sections (safe defaults until permissions exist)
$canWorkOrders = $isCompanyAdmin || $isManager; // Operations (menu label: Work Orders)
$canDeliveries = $isCompanyAdmin || $isManager;
$canMetal      = $isCompanyAdmin || $isManager;
$canInventory  = $isCompanyAdmin || $isManager;
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">
  <title><?= h(APP_NAME . ' — ' . $pageTitle) ?></title>

  <!-- Inter Font -->
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800;900&display=swap" rel="stylesheet">

  <!-- Bootstrap 5 -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Font Awesome -->
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

  <!-- Leaflet -->
  <link href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" rel="stylesheet">

  <!-- App CSS (bump version when editing CSS) -->
  <link href="<?= app_path('assets/css/app.css?v=2') ?>" rel="stylesheet">
</head>
<body>

<div class="so-app">
  <!-- TOP NAV -->
  <header class="so-topbar">
    <div class="so-topbar-left">
      <button class="so-icon-btn d-lg-none" id="sidebarToggle" aria-label="Toggle sidebar">
        <i class="fa-solid fa-bars"></i>
      </button>

      <a href="<?= $isDriverMode ? app_path('driver/home.php') : app_path('dashboard.php') ?>" class="so-brand">
        <span class="so-brand-mark">
          <i class="fa-solid fa-warehouse"></i>
        </span>
        <span class="so-brand-text">
          <span class="so-brand-name">ShedOffice</span><span class="so-brand-dot">.com</span>
        </span>
      </a>

      <?php if (($user['tenant_type'] ?? '') === 'rto'): ?>
        <a href="<?= app_path('select_company.php') ?>" class="so-topnav-link ms-2" style="border:1px solid rgba(255,255,255,0.10);">
          <i class="fa-solid fa-building"></i>
          <?= h($user['active_company_name'] ?: 'Select Company') ?>
        </a>
      <?php endif; ?>

      <!-- TOP NAV LINKS -->
      <nav class="so-topnav d-none d-lg-flex">
        <?php if ($isDriverMode): ?>

          <a class="so-topnav-link <?= $activeNav==='repos'?'active':'' ?>" href="<?= app_path('driver/repos.php') ?>">
            <i class="fa-solid fa-truck-ramp-box"></i> My Repos
          </a>

        <?php else: ?>

          <a class="so-topnav-link <?= $activeNav==='dashboard'?'active':'' ?>" href="<?= app_path('dashboard.php') ?>">
            <i class="fa-solid fa-house"></i> Home
          </a>

          <?php if ($canWorkOrders): ?>
            <a class="so-topnav-link <?= $activeNav==='operations'?'active':'' ?>" href="<?= app_path('operations/index.php') ?>">
              <i class="fa-solid fa-clipboard-list"></i> Work Orders
            </a>
          <?php endif; ?>

          <?php if ($canDeliveries): ?>
            <a class="so-topnav-link <?= $activeNav==='deliveries'?'active':'' ?>" href="<?= app_path('deliveries/deliveries.php') ?>">
              <i class="fa-solid fa-truck"></i> Deliveries
            </a>
          <?php endif; ?>

          <?php if ($canMetal): ?>
            <a class="so-topnav-link <?= $activeNav==='metal_orders'?'active':'' ?>" href="<?= app_path('metal_orders/index.php') ?>">
              <i class="fa-solid fa-industry"></i> Metal Orders
            </a>
          <?php endif; ?>

          <?php if ($canInventory): ?>
            <a class="so-topnav-link <?= $activeNav==='inventory'?'active':'' ?>" href="<?= app_path('inventory/index.php') ?>">
              <i class="fa-solid fa-boxes-stacked"></i> Inventory
            </a>
          <?php endif; ?>

          <?php if ($canRepos): ?>
            <a class="so-topnav-link <?= $activeNav==='repos'?'active':'' ?>" href="<?= app_path('repos/repos_list.php') ?>">
              <i class="fa-solid fa-truck-ramp-box"></i> Repos
            </a>
          <?php endif; ?>

          <?php if ($canRepairs): ?>
            <a class="so-topnav-link <?= $activeNav==='repairs'?'active':'' ?>" href="<?= app_path('repairs/repairs_list.php') ?>">
              <i class="fa-solid fa-screwdriver-wrench"></i> Repairs
            </a>
          <?php endif; ?>

          <?php if ($canGPS): ?>
            <a class="so-topnav-link <?= $activeNav==='gps'?'active':'' ?>" href="<?= app_path('gps/gps_list.php') ?>">
              <i class="fa-solid fa-location-dot"></i> GPS
            </a>
          <?php endif; ?>

          <?php if ($canLocs): ?>
            <a class="so-topnav-link <?= $activeNav==='locations'?'active':'' ?>" href="<?= app_path('locations/locations_list.php') ?>">
              <i class="fa-solid fa-map-location-dot"></i> Locations
            </a>
          <?php endif; ?>

        <?php endif; ?>
      </nav>
    </div>

    <div class="so-topbar-right">
      <?php if (!$isDriverMode): ?>
        <button class="so-icon-btn" aria-label="Notifications">
          <i class="fa-regular fa-bell"></i>
          <span class="so-badge">1</span>
        </button>

        <!-- Desktop only: Settings icon (mobile goes in dropdown) -->
        <a class="so-icon-btn d-none d-lg-inline-flex" aria-label="Settings" href="<?= app_path('admin/settings.php') ?>">
          <i class="fa-solid fa-gear"></i>
        </a>
      <?php endif; ?>

      <div class="dropdown">
        <a class="so-userchip dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
          <span class="so-avatar"><?= h(strtoupper(substr($user['name'] ?? 'U', 0, 1))) ?></span>

          <!-- Desktop only (mobile shows avatar only) -->
          <span class="so-userchip-text d-none d-lg-flex">
            <span class="so-userchip-name"><?= h($user['name'] ?? 'User') ?></span>
            <span class="so-userchip-role">
              <?= h(($user['tenant_type'] ?? '') . ($isCompanyAdmin ? ' · admin' : ($isManager ? ' · manager' : ($isDriver ? ' · driver' : ($isTech ? ' · tech' : ''))))) ?>
            </span>
          </span>
        </a>

        <ul class="dropdown-menu dropdown-menu-dark dropdown-menu-end so-dropdown">
          <?php if (!$isDriverMode): ?>

            <!-- Mobile-only quick links -->
            <li class="d-lg-none">
              <a class="dropdown-item" href="<?= app_path('dashboard.php') ?>">
                <i class="fa-solid fa-house me-2"></i>Home
              </a>
            </li>
            <li class="d-lg-none">
              <a class="dropdown-item" href="<?= app_path('admin/settings.php') ?>">
                <i class="fa-solid fa-gear me-2"></i>Settings
              </a>
            </li>

            <?php if ($canUsers): ?>
              <li class="d-lg-none">
                <a class="dropdown-item" href="<?= app_path('admin/users.php') ?>">
                  <i class="fa-solid fa-users me-2"></i>Users
                </a>
              </li>
            <?php endif; ?>

            <li class="d-lg-none"><hr class="dropdown-divider"></li>

            <!-- Desktop-only items (still fine if shown on mobile, but we keep pattern) -->
            <li><a class="dropdown-item" href="#"><i class="fa-regular fa-id-badge me-2"></i>Profile</a></li>
            <li><a class="dropdown-item" href="#"><i class="fa-solid fa-shield-halved me-2"></i>Security</a></li>
            <li><hr class="dropdown-divider"></li>

          <?php endif; ?>

          <?php if ($canUsers): ?>
            <li class="d-none d-lg-block">
              <a class="dropdown-item" href="<?= app_path('admin/users.php') ?>">
                <i class="fa-solid fa-users me-2"></i>Users
              </a>
            </li>
            <li class="d-none d-lg-block"><hr class="dropdown-divider"></li>
          <?php endif; ?>

          <li><a class="dropdown-item text-danger" href="<?= app_path('logout.php') ?>"><i class="fa-solid fa-right-from-bracket me-2"></i>Log out</a></li>
        </ul>
      </div>
    </div>
  </header>

  <!-- LAYOUT: SIDEBAR + CONTENT -->
  <div class="so-layout">
    <aside class="so-sidebar" id="sidebar">
      <div class="so-sidebar-inner">

        <?php if ($isDriverMode): ?>

          <a class="so-side-link <?= $activeNav==='repos'?'active':'' ?>" href="<?= app_path('driver/repos.php') ?>">
            <i class="fa-solid fa-truck-ramp-box"></i><span>My Repos</span>
          </a>

        <?php else: ?>

          <a class="so-side-link <?= $activeNav==='dashboard'?'active':'' ?>" href="<?= app_path('dashboard.php') ?>">
            <i class="fa-solid fa-house"></i><span>Home</span>
          </a>

          <?php if ($canWorkOrders): ?>
            <a class="so-side-link <?= $activeNav==='operations'?'active':'' ?>" href="<?= app_path('operations/index.php') ?>">
              <i class="fa-solid fa-clipboard-list"></i><span>Work Orders</span>
            </a>
          <?php endif; ?>

          <?php if ($canDeliveries): ?>
            <a class="so-side-link <?= $activeNav==='deliveries'?'active':'' ?>" href="<?= app_path('deliveries/deliveries.php') ?>">
              <i class="fa-solid fa-truck"></i><span>Deliveries</span>
            </a>
          <?php endif; ?>

          <?php if ($canMetal): ?>
            <a class="so-side-link <?= $activeNav==='metal_orders'?'active':'' ?>" href="<?= app_path('metal_orders/index.php') ?>">
              <i class="fa-solid fa-industry"></i><span>Metal Orders</span>
            </a>
          <?php endif; ?>

          <?php if ($canInventory): ?>
            <a class="so-side-link <?= $activeNav==='inventory'?'active':'' ?>" href="<?= app_path('inventory/index.php') ?>">
              <i class="fa-solid fa-boxes-stacked"></i><span>Inventory</span>
            </a>
          <?php endif; ?>

          <?php if ($canRepos): ?>
            <a class="so-side-link <?= $activeNav==='repos'?'active':'' ?>" href="<?= app_path('repos/repos_list.php') ?>">
              <i class="fa-solid fa-truck-ramp-box"></i><span>Repos</span>
            </a>
            <a class="so-side-link" href="<?= app_path('repos/invoices_list.php') ?>">
              <i class="fa-solid fa-receipt"></i><span>Repo Invoices</span>
            </a>
          <?php endif; ?>

          <?php if ($canRepairs): ?>
            <a class="so-side-link <?= $activeNav==='repairs'?'active':'' ?>" href="<?= app_path('repairs/repairs_list.php') ?>">
              <i class="fa-solid fa-screwdriver-wrench"></i><span>Repairs</span>
            </a>
          <?php endif; ?>

          <?php if ($canGPS): ?>
            <a class="so-side-link <?= $activeNav==='gps'?'active':'' ?>" href="<?= app_path('gps/gps_list.php') ?>">
              <i class="fa-solid fa-location-dot"></i><span>GPS</span>
            </a>
          <?php endif; ?>

          <?php if ($canLocs): ?>
            <a class="so-side-link <?= $activeNav==='locations'?'active':'' ?>" href="<?= app_path('locations/locations_list.php') ?>">
              <i class="fa-solid fa-map-location-dot"></i><span>Locations</span>
            </a>
          <?php endif; ?>

          <div class="so-side-section">Administration</div>

          <?php if ($canUsers): ?>
            <a class="so-side-link <?= $activeNav==='users'?'active':'' ?>" href="<?= app_path('admin/users.php') ?>">
              <i class="fa-solid fa-users"></i><span>Users</span>
            </a>
          <?php endif; ?>

          <?php if ($canSettings): ?>
            <a class="so-side-link <?= $activeNav==='settings'?'active':'' ?>" href="<?= app_path('admin/settings.php') ?>">
              <i class="fa-solid fa-sliders"></i><span>Settings</span>
            </a>
          <?php endif; ?>

        <?php endif; ?>

      </div>

      <div class="so-sidebar-footer">
        <div class="so-sidebar-user">
          <span class="so-avatar sm"><?= h(strtoupper(substr($user['name'] ?? 'U', 0, 1))) ?></span>
          <div class="so-sidebar-usertext">
            <div class="name"><?= h($user['name'] ?? 'User') ?></div>
            <div class="sub"><?= $isDriverMode ? 'Driver mode' : 'Signed in' ?></div>
          </div>
        </div>
        <a class="so-sidebar-logout" href="<?= app_path('logout.php') ?>" title="Log out">
          <i class="fa-solid fa-right-from-bracket"></i>
        </a>
      </div>
    </aside>

    <main class="so-content">
