<?php
// /app/operations/workorder_team_ajax.php
declare(strict_types=1);



require_once __DIR__ . '/_bootstrap.php';
require_once __DIR__ . '/includes/bootstrap.php';
require_once __DIR__ . '/_lib.php';

header('Content-Type: application/json; charset=utf-8');

$companyId = ops_require_company_scope();
if (!ops_can_manage()) { http_response_code(403); echo json_encode(['ok'=>false,'msg'=>'Forbidden']); exit; }

csrf_verify();

$pdo = db_safe();

$action = (string)($_POST['action'] ?? '');
$workOrderId = (int)($_POST['work_order_id'] ?? 0);

if ($workOrderId <= 0) { http_response_code(400); echo json_encode(['ok'=>false,'msg'=>'Missing work_order_id']); exit; }

$wo = $pdo->prepare("SELECT id FROM ops_work_orders WHERE id=:id AND company_id=:cid");
$wo->execute([':id'=>$workOrderId, ':cid'=>$companyId]);
if (!$wo->fetchColumn()) { http_response_code(404); echo json_encode(['ok'=>false,'msg'=>'Work order not found']); exit; }

$actor = function_exists('current_user_id') ? (int)current_user_id() : null;

try {
  if ($action === 'set_lead') {
    $uid = (int)($_POST['user_id'] ?? 0);

    $pdo->prepare("DELETE FROM ops_work_order_assignees WHERE work_order_id=:wo AND role='lead'")
        ->execute([':wo'=>$workOrderId]);

    if ($uid > 0) {
      $pdo->prepare("INSERT INTO ops_work_order_assignees (work_order_id, user_id, role) VALUES (:wo,:uid,'lead')
                     ON DUPLICATE KEY UPDATE role='lead'")
          ->execute([':wo'=>$workOrderId, ':uid'=>$uid]);
    }

    $pdo->prepare("INSERT INTO ops_work_order_events (work_order_id, actor_user_id, event_type, message, meta_json)
                   VALUES (:wo,:actor,'assign_lead',:msg,:meta)")
        ->execute([
          ':wo'=>$workOrderId,
          ':actor'=>$actor,
          ':msg'=>$uid>0 ? 'Lead assigned' : 'Lead cleared',
          ':meta'=>json_encode(['lead_user_id'=>$uid], JSON_UNESCAPED_SLASHES)
        ]);

    echo json_encode(['ok'=>true]);
    exit;
  }

  if ($action === 'add') {
    $uid = (int)($_POST['user_id'] ?? 0);
    $role = (string)($_POST['role'] ?? 'tech');
    if (!in_array($role, ['tech','helper'], true)) $role = 'tech';
    if ($uid <= 0) throw new RuntimeException('Invalid user');

    $pdo->prepare("INSERT INTO ops_work_order_assignees (work_order_id, user_id, role)
                   VALUES (:wo,:uid,:role)
                   ON DUPLICATE KEY UPDATE role=VALUES(role)")
        ->execute([':wo'=>$workOrderId, ':uid'=>$uid, ':role'=>$role]);

    $pdo->prepare("INSERT INTO ops_work_order_events (work_order_id, actor_user_id, event_type, message, meta_json)
                   VALUES (:wo,:actor,'assign_member','Team member assigned',:meta)")
        ->execute([
          ':wo'=>$workOrderId,
          ':actor'=>$actor,
          ':meta'=>json_encode(['user_id'=>$uid,'role'=>$role], JSON_UNESCAPED_SLASHES)
        ]);

    echo json_encode(['ok'=>true]);
    exit;
  }

  if ($action === 'remove') {
    $uid = (int)($_POST['user_id'] ?? 0);
    if ($uid <= 0) throw new RuntimeException('Invalid user');

    $pdo->prepare("DELETE FROM ops_work_order_assignees WHERE work_order_id=:wo AND user_id=:uid")
        ->execute([':wo'=>$workOrderId, ':uid'=>$uid]);

    $pdo->prepare("INSERT INTO ops_work_order_events (work_order_id, actor_user_id, event_type, message, meta_json)
                   VALUES (:wo,:actor,'unassign_member','Team member removed',:meta)")
        ->execute([
          ':wo'=>$workOrderId,
          ':actor'=>$actor,
          ':meta'=>json_encode(['user_id'=>$uid], JSON_UNESCAPED_SLASHES)
        ]);

    echo json_encode(['ok'=>true]);
    exit;
  }

  http_response_code(400);
  echo json_encode(['ok'=>false,'msg'=>'Unknown action']);
} catch (Throwable $e) {
  http_response_code(400);
  echo json_encode(['ok'=>false,'msg'=>$e->getMessage()]);
}
