<?php
// /app/operations/service_save.php
declare(strict_types=1);



require_once __DIR__ . '/_bootstrap.php';
require_once __DIR__ . '/includes/bootstrap.php';
require_once __DIR__ . '/_lib.php';

$companyId = ops_require_company_scope();
if (!ops_can_configure()) { http_response_code(403); exit('Forbidden'); }

csrf_verify();
$pdo = db_safe();

$id = (int)($_POST['id'] ?? 0);
$isNew = ($id <= 0);

$name = trim((string)($_POST['service_name'] ?? ''));
$code = trim((string)($_POST['service_code'] ?? ''));
$desc = trim((string)($_POST['description'] ?? ''));

if ($name === '' || $code === '') { http_response_code(400); exit('Missing required fields'); }

$code = strtolower(preg_replace('/[^a-z0-9_\-]/i', '_', $code));
$prio = max(1, min(5, (int)($_POST['default_priority'] ?? 3)));
$dueDays = max(0, min(365, (int)($_POST['default_due_days'] ?? 7)));
$assignee = ($_POST['default_assignee_user_id'] ?? '') !== '' ? (int)$_POST['default_assignee_user_id'] : null;
$isActive = (int)($_POST['is_active'] ?? 1) === 1 ? 1 : 0;

try {
  if ($isNew) {
    $stmt = $pdo->prepare("
      INSERT INTO ops_services
        (company_id, service_code, service_name, description, default_priority, default_due_days, default_assignee_user_id, is_active)
      VALUES
        (:cid,:code,:name,:desc,:prio,:due,:assignee,:active)
    ");
    $stmt->execute([
      ':cid'=>$companyId, ':code'=>$code, ':name'=>$name, ':desc'=>$desc ?: null,
      ':prio'=>$prio, ':due'=>$dueDays, ':assignee'=>$assignee, ':active'=>$isActive
    ]);
    header('Location: /app/operations/services.php');
    exit;
  }

  $stmt = $pdo->prepare("
    UPDATE ops_services
       SET service_code=:code,
           service_name=:name,
           description=:desc,
           default_priority=:prio,
           default_due_days=:due,
           default_assignee_user_id=:assignee,
           is_active=:active
     WHERE id=:id AND company_id=:cid
  ");
  $stmt->execute([
    ':code'=>$code, ':name'=>$name, ':desc'=>$desc ?: null,
    ':prio'=>$prio, ':due'=>$dueDays, ':assignee'=>$assignee, ':active'=>$isActive,
    ':id'=>$id, ':cid'=>$companyId
  ]);

  header('Location: /app/operations/services.php');
  exit;
} catch (PDOException $e) {
  // Most common: duplicate code
  http_response_code(400);
  echo "Save failed: ".$e->getMessage();
}
