<?php
// /app/operations/index.php
declare(strict_types=1);



require_once __DIR__ . '/_bootstrap.php';
require_once __DIR__ . '/includes/bootstrap.php';
require_once __DIR__ . '/_lib.php';

$pageTitle = 'Operations';
$activeNav = 'operations';

$companyId = ops_require_company_scope();
if (!ops_can_view()) { http_response_code(403); exit('Forbidden'); }

$pdo = db_safe();

$counts = $pdo->prepare("
  SELECT
    SUM(status='new')         AS cnt_new,
    SUM(status='scheduled')   AS cnt_scheduled,
    SUM(status='in_progress') AS cnt_in_progress,
    SUM(status='blocked')     AS cnt_blocked,
    SUM(status='completed')   AS cnt_completed,
    SUM(status='canceled')    AS cnt_canceled
  FROM ops_work_orders
  WHERE company_id = :cid
");
$counts->execute([':cid'=>$companyId]);
$c = $counts->fetch(PDO::FETCH_ASSOC) ?: [];

$svc = $pdo->prepare("SELECT id, service_name FROM ops_services WHERE company_id=:cid AND is_active=1 ORDER BY service_name");
$svc->execute([':cid'=>$companyId]);
$services = $svc->fetchAll(PDO::FETCH_ASSOC);

require_once __DIR__ . '/../includes/header.php';

$activeOps = 'workorders';
require __DIR__ . '/_subnav.php';
?>
<div class="row g-3">
  <div class="col-12 col-lg-8">
    <div class="card shadow-sm">
      <div class="card-header bg-dark text-white"><strong>Work Order Overview</strong></div>
      <div class="card-body">
        <div class="row g-2">
          <?php
            $tiles = [
              ['New', (int)($c['cnt_new'] ?? 0), 'secondary', 'status=new'],
              ['Scheduled', (int)($c['cnt_scheduled'] ?? 0), 'info', 'status=scheduled'],
              ['In Progress', (int)($c['cnt_in_progress'] ?? 0), 'warning', 'status=in_progress'],
              ['Blocked', (int)($c['cnt_blocked'] ?? 0), 'danger', 'status=blocked'],
              ['Completed', (int)($c['cnt_completed'] ?? 0), 'success', 'status=completed'],
              ['Canceled', (int)($c['cnt_canceled'] ?? 0), 'dark', 'status=canceled'],
            ];
            foreach ($tiles as [$label,$val,$color,$qs]):
          ?>
          <div class="col-6 col-md-4">
            <a class="text-decoration-none" href="/app/operations/workorders_list.php?<?=h($qs)?>">
              <div class="border rounded-4 p-3 h-100">
                <div class="text-muted small"><?=h($label)?></div>
                <div class="fs-3 fw-bold"><?= (int)$val ?></div>
                <span class="badge bg-<?=h($color)?>">View</span>
              </div>
            </a>
          </div>
          <?php endforeach; ?>
        </div>
      </div>
    </div>

    <div class="card shadow-sm mt-3">
      <div class="card-header"><strong>Quick Actions</strong></div>
      <div class="card-body d-flex flex-wrap gap-2">
        <a class="btn btn-primary btn-sm" href="/app/operations/workorder_view.php?id=new">Create Work Order</a>
        <?php if (ops_can_configure()): ?>
          <a class="btn btn-outline-dark btn-sm" href="/app/operations/services.php">Manage Services</a>
          <a class="btn btn-outline-dark btn-sm" href="/app/operations/addon_mapping.php">Configure Add-on Mapping</a>
        <?php endif; ?>
      </div>
    </div>
  </div>

  <div class="col-12 col-lg-4">
    <div class="card shadow-sm">
      <div class="card-header"><strong>Active Services</strong></div>
      <div class="card-body">
        <?php if (!$services): ?>
          <div class="text-muted">No services configured.</div>
        <?php else: ?>
          <ul class="list-group list-group-flush">
            <?php foreach ($services as $s): ?>
              <li class="list-group-item d-flex align-items-center justify-content-between">
                <span><?=h($s['service_name'])?></span>
                <a class="btn btn-sm btn-outline-secondary" href="/app/operations/workorders_list.php?service_id=<?= (int)$s['id'] ?>">View</a>
              </li>
            <?php endforeach; ?>
          </ul>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
