<?php
// /app/operations/cron/cron_backfill_workorders.php
declare(strict_types=1);



require_once __DIR__ . '/../_bootstrap.php';
require_once __DIR__ . '/../_bootstrap.php';
/**
 * Optional nightly reconciliation.
 * - Re-queues failed inbox items from the last 7 days to pending (so processor retries).
 * - Can be extended to pull from a separate orders table if desired.
 */

require_once __DIR__ . '/../_bootstrap.php';
require_once __DIR__ . '/../../includes/db.php';

function dbw(): PDO {
  if (function_exists('db')) return db();
  if (isset($GLOBALS['pdo']) && $GLOBALS['pdo'] instanceof PDO) return $GLOBALS['pdo'];
  throw new RuntimeException('No DB connection');
}

$pdo = dbw();
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

$pdo->exec("
  UPDATE ops_webhook_inbox
     SET status='pending', error_message=NULL
   WHERE status='failed'
     AND received_at >= (UTC_TIMESTAMP() - INTERVAL 7 DAY)
");

if (php_sapi_name() === 'cli') echo "Re-queued recent failed inbox items.".PHP_EOL;
