// /assets/js/app.js
(function () {
  const sidebar = document.getElementById('sidebar');
  const toggle = document.getElementById('sidebarToggle');

  if (toggle && sidebar) {
    toggle.addEventListener('click', () => sidebar.classList.toggle('open'));
  }

  // Leaflet demo map
  const mapEl = document.getElementById('repoMap');
  if (mapEl && window.L) {
    const map = L.map('repoMap', { scrollWheelZoom: false }).setView([37.8, -85.8], 6);

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
      attribution: '&copy; OpenStreetMap contributors'
    }).addTo(map);

    const points = [
      { name: 'Assigned Repo', lat: 37.2645, lng: -88.2427, color: 'red' },      // Salem, KY
      { name: 'Assigned Repo', lat: 35.6145, lng: -88.8139, color: 'red' },      // Jackson, TN
      { name: 'Unassigned Repo', lat: 34.7304, lng: -86.5861, color: 'orange' }, // Madison/Huntsville area
      { name: 'Assigned Repo', lat: 32.0643, lng: -82.9046, color: 'red' }       // McRae, GA
    ];

    points.forEach(p => {
      const icon = L.divIcon({
        className: 'so-pin',
        html: `<div style="
          width:14px;height:14px;border-radius:999px;
          background:${p.color === 'red' ? '#cf1f1f' : '#f59e0b'};
          border:2px solid #fff; box-shadow:0 10px 16px rgba(0,0,0,0.20);
        "></div>`,
        iconSize: [14,14],
        iconAnchor: [7,7]
      });
      L.marker([p.lat, p.lng], { icon }).addTo(map).bindPopup(p.name);
    });
  }
})();
