<?php
// /app/deliveries/drivers_list.php
declare(strict_types=1);

require_once __DIR__ . '/_lib.php';
if (!d_can_view()) { http_response_code(403); exit('Forbidden'); }

$pageTitle = 'Delivery Drivers';
$activeNav = 'deliveries';
$tenantId = company_context_id();

$drivers = [];
try {
  $drivers = $pdo->query("SELECT id, name, first_name, last_name, email FROM users WHERE role='driver' ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
} catch (Throwable $e) { $drivers = []; }

$counts = [];
if ($drivers) {
  $ids = array_map(fn($d)=> (int)$d['id'], $drivers);
  $in = implode(',', array_fill(0, count($ids), '?'));
  $q = $pdo->prepare("SELECT driver_user_id, COUNT(*) c FROM orders WHERE tenant_id=? AND driver_user_id IN ($in) AND status IN ('submitted','processed') GROUP BY driver_user_id");
  $q->execute(array_merge([$tenantId], $ids));
  foreach ($q->fetchAll(PDO::FETCH_ASSOC) as $r) $counts[(int)$r['driver_user_id']] = (int)$r['c'];
}

require_once __DIR__ . '/../includes/header.php';
?>
<div class="container-fluid">
  <div class="row">
    <div class="col-12">
      <div class="so-page-title">Drivers</div>
      <div class="so-page-sub">Driver roster and active delivery counts.</div>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-12">
      <div class="so-card">
        <div class="so-card-h">
          <h5 class="so-card-title"><i class="fa-solid fa-users me-2" style="color:#cf1f1f"></i>Drivers</h5>
          <a class="so-btn btn btn-sm" href="<?= app_path('deliveries/deliveries.php') ?>" style="border-color:rgba(18,20,24,0.10);background:#fff;color:#111827;">
            <i class="fa-solid fa-arrow-left me-2"></i>Back
          </a>
        </div>
        <div class="so-card-body">
          <div class="table-responsive">
            <table class="table so-table align-middle">
              <thead>
                <tr>
                  <th>Driver</th>
                  <th>Email</th>
                  <th class="text-end">Active Assignments</th>
                </tr>
              </thead>
              <tbody>
                <?php if (!$drivers): ?>
                  <tr><td colspan="3" class="text-center text-muted py-4">No drivers found.</td></tr>
                <?php else: ?>
                  <?php foreach ($drivers as $d): ?>
                    <?php $nm = d_driver_label($d); ?>
                    <tr>
                      <td><strong><?= h($nm) ?></strong></td>
                      <td class="text-muted small"><?= h((string)($d['email'] ?? '')) ?></td>
                      <td class="text-end"><span class="so-pill gray"><?= (int)($counts[(int)$d['id']] ?? 0) ?></span></td>
                    </tr>
                  <?php endforeach; ?>
                <?php endif; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
