<?php
// /app/deliveries/delivery_view.php
declare(strict_types=1);

require_once __DIR__ . '/_lib.php';
if (!d_can_view()) { http_response_code(403); exit('Forbidden'); }

$pageTitle = 'Delivery';
$activeNav = 'deliveries';
$tenantId  = company_context_id();

$orderId = (int)($_GET['id'] ?? 0);
if ($orderId <= 0) { http_response_code(400); exit('Missing id'); }

$st = $pdo->prepare("
  SELECT o.*, u.id AS driver_id, u.name AS driver_name, u.first_name AS driver_first_name, u.last_name AS driver_last_name, u.email AS driver_email
  FROM orders o
  LEFT JOIN users u ON u.id = o.driver_user_id
  WHERE o.id=:id AND o.tenant_id=:tid
  LIMIT 1
");
$st->execute([':id'=>$orderId, ':tid'=>$tenantId]);
$o = $st->fetch(PDO::FETCH_ASSOC);
if (!$o) { http_response_code(404); exit('Order not found'); }

$notes = $pdo->prepare("
  SELECT n.*, u.name
  FROM delivery_notes n
  LEFT JOIN users u ON u.id = n.user_id
  WHERE n.tenant_id=:tid AND n.order_id=:oid
  ORDER BY n.created_at DESC
  LIMIT 50
");
$notes->execute([':tid'=>$tenantId, ':oid'=>$orderId]);
$notes = $notes->fetchAll(PDO::FETCH_ASSOC);

$drivers = [];
if (d_can_manage()) {
  try {
    $drivers = $pdo->query("SELECT id, name, first_name, last_name, email FROM users WHERE role='driver' ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);
  } catch (Throwable $e) { $drivers = []; }
}

[$pillCls,$pillLbl] = d_status_pill((string)$o['status']);

require_once __DIR__ . '/../includes/header.php';
?>
<div class="container-fluid">
  <div class="row">
    <div class="col-12">
      <div class="so-page-title">Delivery: <?= h((string)$o['order_number']) ?></div>
      <div class="so-page-sub">View order details, assign driver, update status, and track notes.</div>
    </div>
  </div>

  <div class="row g-3 mb-3">
    <div class="col-12 col-xl-8">
      <div class="so-card">
        <div class="so-card-h">
          <h5 class="so-card-title"><i class="fa-solid fa-receipt me-2" style="color:#cf1f1f"></i>Order Details</h5>
          <div class="d-flex gap-2">
            <a class="so-btn btn btn-sm" href="<?= app_path('deliveries/deliveries.php') ?>" style="border-color:rgba(18,20,24,0.10);background:#fff;color:#111827;">
              <i class="fa-solid fa-arrow-left me-2"></i>Back
            </a>
          </div>
        </div>
        <div class="so-card-body">
          <div class="row g-2">
            <div class="col-12 col-md-6">
              <div class="text-muted small">Customer</div>
              <strong><?= h((string)($o['customer_name'] ?? '')) ?></strong>
              <div class="text-muted small mt-1"><?= h((string)($o['customer_phone_primary'] ?? '')) ?> · <?= h((string)($o['customer_email'] ?? '')) ?></div>
            </div>
            <div class="col-12 col-md-6">
              <div class="text-muted small">Status</div>
              <span class="so-pill <?= h($pillCls) ?>"><?= h($pillLbl) ?></span>
              <div class="text-muted small mt-1">Updated: <?= h((string)$o['updated_at']) ?></div>
            </div>

            <div class="col-12">
              <div class="text-muted small mt-2">Delivery Address</div>
              <strong><?= h((string)($o['delivery_street_line_one'] ?? '')) ?></strong>
              <div class="text-muted small"><?= h((string)($o['delivery_city'] ?? '')) ?>, <?= h((string)($o['delivery_state'] ?? '')) ?> <?= h((string)($o['delivery_zip'] ?? '')) ?></div>
            </div>

            <div class="col-12 col-md-6">
              <div class="text-muted small mt-2">Building</div>
              <div><strong><?= h((string)($o['size'] ?? '')) ?></strong> <?= h((string)($o['model'] ?? '')) ?></div>
              <div class="text-muted small">Serial: <?= h((string)($o['serial_number'] ?? '')) ?></div>
            </div>
            <div class="col-12 col-md-6">
              <div class="text-muted small mt-2">Route / Distance</div>
              <div class="text-muted small">From: <?= h((string)($o['from_location'] ?? '')) ?></div>
              <div class="text-muted small">Miles: <?= h((string)($o['miles'] ?? '')) ?></div>
            </div>
          </div>

          <?php if (d_can_manage()): ?>
            <hr class="my-3">

            <form method="post" action="<?= app_path('deliveries/delivery_ajax.php') ?>" class="row g-2 align-items-end">
              <input type="hidden" name="_csrf" value="<?= h(csrf_token()) ?>">
              <input type="hidden" name="order_id" value="<?= (int)$o['id'] ?>">

              <div class="col-12 col-md-4">
                <label class="form-label small text-muted mb-1">Driver</label>
                <select class="form-select" name="driver_user_id">
                  <option value="">— Unassigned —</option>
                  <?php foreach ($drivers as $d): ?>
                    <?php $dName = d_driver_label($d); ?>
                    <option value="<?= (int)$d['id'] ?>" <?= ((int)$o['driver_user_id']===(int)$d['id'])?'selected':'' ?>>
                      <?= h($dName) ?>
                    </option>
                  <?php endforeach; ?>
                </select>
              </div>

              <div class="col-12 col-md-4">
                <label class="form-label small text-muted mb-1">Status</label>
                <select class="form-select" name="status">
                  <?php foreach (['submitted','processed','delivered','canceled'] as $st): ?>
                    <option value="<?= h($st) ?>" <?= ((string)$o['status']===$st)?'selected':'' ?>><?= h(ucfirst($st)) ?></option>
                  <?php endforeach; ?>
                </select>
              </div>

              <div class="col-12 col-md-4 d-grid">
                <button class="so-btn btn btn-sm" type="submit" name="action" value="update">
                  <i class="fa-solid fa-floppy-disk me-2"></i>Save
                </button>
              </div>
            </form>
          <?php endif; ?>

        </div>
      </div>
    </div>

    <div class="col-12 col-xl-4">
      <div class="so-card">
        <div class="so-card-h">
          <h5 class="so-card-title"><i class="fa-solid fa-note-sticky me-2" style="color:#cf1f1f"></i>Notes</h5>
        </div>
        <div class="so-card-body">
          <?php if (d_can_manage()): ?>
            <form method="post" action="<?= app_path('deliveries/note_save.php') ?>" class="mb-3">
              <input type="hidden" name="_csrf" value="<?= h(csrf_token()) ?>">
              <input type="hidden" name="order_id" value="<?= (int)$o['id'] ?>">
              <textarea class="form-control" name="note" rows="3" placeholder="Add a note..."></textarea>
              <button class="so-btn btn btn-sm mt-2" type="submit"><i class="fa-solid fa-plus me-2"></i>Add Note</button>
            </form>
          <?php endif; ?>

          <?php if (!$notes): ?>
            <div class="text-muted">No notes yet.</div>
          <?php else: ?>
            <?php foreach ($notes as $n): ?>
              <div class="border rounded-3 p-2 mb-2">
                <div class="text-muted small">
                  <?= h((string)($n['created_at'] ?? '')) ?>
                  <?php if (!empty($n['name'])): ?> · <?= h((string)$n['name']) ?><?php endif; ?>
                </div>
                <div><?= nl2br(h((string)$n['note'])) ?></div>
              </div>
            <?php endforeach; ?>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
