<?php
// /app/deliveries/delivery_ajax.php
declare(strict_types=1);

require_once __DIR__ . '/_lib.php';
if (!d_can_manage()) { http_response_code(403); exit('Forbidden'); }

if (!csrf_validate((string)($_POST['_csrf'] ?? ''))) {
  http_response_code(403);
  exit('CSRF failed');
}

$tenantId = company_context_id();

$action = (string)($_POST['action'] ?? 'update');
$orderId = (int)($_POST['order_id'] ?? 0);
if ($orderId <= 0) { http_response_code(400); exit('Missing order_id'); }

$st = $pdo->prepare("SELECT id FROM orders WHERE id=:id AND tenant_id=:tid");
$st->execute([':id'=>$orderId, ':tid'=>$tenantId]);
if (!$st->fetchColumn()) { http_response_code(404); exit('Not found'); }

if ($action === 'driver') {
  $driverId = ($_POST['driver_user_id'] ?? '') === '' ? null : (int)$_POST['driver_user_id'];
  $pdo->prepare("UPDATE orders SET driver_user_id=:d WHERE id=:id AND tenant_id=:tid")
      ->execute([':d'=>$driverId, ':id'=>$orderId, ':tid'=>$tenantId]);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode(['ok'=>true]);
  exit;
}

$driverId = ($_POST['driver_user_id'] ?? '') === '' ? null : (int)$_POST['driver_user_id'];
$status   = trim((string)($_POST['status'] ?? ''));
if (!in_array($status, ['submitted','processed','delivered','canceled'], true)) $status = 'unknown';

$pdo->prepare("UPDATE orders SET driver_user_id=:d, status=:s WHERE id=:id AND tenant_id=:tid")
    ->execute([':d'=>$driverId, ':s'=>$status, ':id'=>$orderId, ':tid'=>$tenantId]);

header('Location: ' . app_path('deliveries/delivery_view.php?id=' . $orderId));
exit;
