<?php
// /app/deliveries/deliveries_optimize.php
declare(strict_types=1);

require_once __DIR__ . '/_lib.php';
if (!d_can_view()) { http_response_code(403); exit('Forbidden'); }

$pageTitle = 'Optimize Loads';
$activeNav = 'deliveries';
$tenantId = company_context_id();

/**
 * Minimal optimizer:
 * - selects active, unassigned deliveries (submitted/processed with driver_user_id NULL)
 * - groups by delivery_state then chunks into groups of 5
 * This is a placeholder for your full load optimization logic (distance + plant + trailer footage).
 */
$q = $pdo->prepare("
  SELECT id, order_number, customer_name, delivery_city, delivery_state, serial_number, size, model
  FROM orders
  WHERE tenant_id=:tid
    AND status IN ('submitted','processed')
    AND (driver_user_id IS NULL OR driver_user_id=0)
  ORDER BY delivery_state, delivery_city, updated_at DESC
  LIMIT 300
");
$q->execute([':tid'=>$tenantId]);
$rows = $q->fetchAll(PDO::FETCH_ASSOC);

$groups = [];
foreach ($rows as $r) {
  $key = (string)($r['delivery_state'] ?? 'Unknown');
  $groups[$key][] = $r;
}

require_once __DIR__ . '/../includes/header.php';
?>
<div class="container-fluid">
  <div class="row">
    <div class="col-12">
      <div class="so-page-title">Optimize Loads</div>
      <div class="so-page-sub">Suggested delivery groupings (starter). We’ll layer in plant selection, trailer footage, and route miles next.</div>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-12">
      <div class="so-card">
        <div class="so-card-h">
          <h5 class="so-card-title"><i class="fa-solid fa-route me-2" style="color:#cf1f1f"></i>Suggestions</h5>
          <a class="so-btn btn btn-sm" href="<?= app_path('deliveries/deliveries.php') ?>" style="border-color:rgba(18,20,24,0.10);background:#fff;color:#111827;">
            <i class="fa-solid fa-arrow-left me-2"></i>Back
          </a>
        </div>
        <div class="so-card-body">
          <?php if (!$rows): ?>
            <div class="text-muted">No unassigned active deliveries found.</div>
          <?php else: ?>
            <?php foreach ($groups as $state => $items): ?>
              <div class="mb-4">
                <h6 class="mb-2"><strong><?= h($state) ?></strong> <span class="text-muted">(<?= count($items) ?>)</span></h6>
                <?php
                  $chunks = array_chunk($items, 5);
                  foreach ($chunks as $i => $chunk):
                ?>
                  <div class="border rounded-3 p-2 mb-2">
                    <div class="text-muted small mb-2">Load <?= ($i+1) ?> (<?= count($chunk) ?> stops)</div>
                    <div class="table-responsive">
                      <table class="table so-table align-middle mb-0">
                        <thead>
                          <tr>
                            <th>Order</th>
                            <th>Customer</th>
                            <th>City</th>
                            <th>Building</th>
                            <th></th>
                          </tr>
                        </thead>
                        <tbody>
                          <?php foreach ($chunk as $r): ?>
                            <tr>
                              <td><strong><?= h((string)$r['order_number']) ?></strong><div class="text-muted small"><?= h((string)$r['serial_number']) ?></div></td>
                              <td><?= h((string)$r['customer_name']) ?></td>
                              <td><?= h((string)$r['delivery_city']) ?></td>
                              <td class="text-muted small"><?= h((string)$r['size']) ?> <?= h((string)$r['model']) ?></td>
                              <td class="text-end">
                                <a class="text-muted" href="<?= app_path('deliveries/delivery_view.php?id='.(int)$r['id']) ?>"><i class="fa-solid fa-chevron-right"></i></a>
                              </td>
                            </tr>
                          <?php endforeach; ?>
                        </tbody>
                      </table>
                    </div>
                  </div>
                <?php endforeach; ?>
              </div>
            <?php endforeach; ?>
          <?php endif; ?>
        </div>
      </div>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
