<?php
// /app/deliveries/deliveries_map.php
declare(strict_types=1);

require_once __DIR__ . '/_lib.php';
if (!d_can_view()) { http_response_code(403); exit('Forbidden'); }

$pageTitle = 'Deliveries Map';
$activeNav = 'deliveries';
$tenantId = company_context_id();

$q = $pdo->prepare("
  SELECT id, order_number, customer_name, serial_number, status,
         delivery_city, delivery_state, delivery_street_line_one,
         dest_lat, dest_lng
  FROM orders
  WHERE tenant_id=:tid AND dest_lat IS NOT NULL AND dest_lng IS NOT NULL
  ORDER BY updated_at DESC
  LIMIT 1000
");
$q->execute([':tid'=>$tenantId]);
$rows = $q->fetchAll(PDO::FETCH_ASSOC);

require_once __DIR__ . '/../includes/header.php';
?>
<div class="container-fluid">
  <div class="row">
    <div class="col-12">
      <div class="so-page-title">Deliveries Map</div>
      <div class="so-page-sub">Visualize delivery locations with GPS coordinates.</div>
    </div>
  </div>

  <div class="row g-3">
    <div class="col-12">
      <div class="so-card">
        <div class="so-card-h">
          <h5 class="so-card-title"><i class="fa-solid fa-map-location-dot me-2" style="color:#cf1f1f"></i>Map</h5>
          <a class="so-btn btn btn-sm" href="<?= app_path('deliveries/deliveries.php') ?>" style="border-color:rgba(18,20,24,0.10);background:#fff;color:#111827;">
            <i class="fa-solid fa-arrow-left me-2"></i>Back
          </a>
        </div>
        <div class="so-card-body">
          <div id="deliveriesMap" class="so-map" style="height:520px;"></div>
        </div>
      </div>
    </div>
  </div>
</div>

<script>
  const rows = <?= json_encode($rows, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) ?>;

  const map = L.map('deliveriesMap');
  const osm = L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', { maxZoom: 19 });
  osm.addTo(map);

  const bounds = [];
  rows.forEach(r => {
    if (!r.dest_lat || !r.dest_lng) return;
    const lat = parseFloat(r.dest_lat), lng = parseFloat(r.dest_lng);
    bounds.push([lat,lng]);
    const label = `<strong>${r.order_number}</strong><br>${(r.customer_name||'')}<br>${(r.delivery_city||'')}, ${(r.delivery_state||'')}<br><span style="opacity:.8">${(r.serial_number||'')}</span>`;
    L.marker([lat,lng]).addTo(map).bindPopup(label);
  });

  if (bounds.length) {
    map.fitBounds(bounds, {padding:[30,30]});
  } else {
    map.setView([37.8,-96], 4);
  }
</script>

<?php require_once __DIR__ . '/../includes/footer.php'; ?>
