<?php
// /app/deliveries/_lib.php
declare(strict_types=1);

require_once __DIR__ . '/../includes/auth.php';
require_company_context_if_rto();

require_once __DIR__ . '/../includes/acl.php';
require_once __DIR__ . '/../includes/scope.php';
require_once __DIR__ . '/../includes/db.php';

$pdo = db();
acl_bootstrap($pdo);

function d_can_view(): bool {
  return user_has_role('company_admin') || user_has_role('manager') || user_can('deliveries.view');
}
function d_can_manage(): bool {
  return user_has_role('company_admin') || user_has_role('manager') || user_can('deliveries.manage');
}

function d_status_pill(string $st): array {
  $st = strtolower(trim($st));
  return match ($st) {
    'submitted' => ['blue','Submitted'],
    'processed' => ['orange','Processed'],
    'delivered' => ['blue','Delivered'],
    'canceled'  => ['gray','Canceled'],
    default     => ['gray', $st ?: 'Unknown'],
  };
}

function d_driver_label(array $u): string {
  if (!empty($u['name'])) return (string)$u['name'];
  $nm = trim(((string)($u['first_name'] ?? '')).' '.((string)($u['last_name'] ?? '')));
  if ($nm !== '') return $nm;
  if (!empty($u['email'])) return (string)$u['email'];
  return 'User #'.(int)($u['id'] ?? 0);
}
